% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFrameAnnotationTrack.R
\name{trackSize,DataFrameAnnotationTrack-method}
\alias{trackSize,DataFrameAnnotationTrack-method}
\title{Retrieve the size of the DataFrameAnnotationTrack}
\usage{
\S4method{trackSize}{DataFrameAnnotationTrack}(obj)
}
\arguments{
\item{obj}{An object of class UCSCBedAnnotationTrack}
}
\value{
The number of elements
}
\description{
Retrieve the size of the DataFrameAnnotationTrack
}
\examples{
base.loc <- 88883100
tbl <- data.frame(chrom=rep("chr5", 3),
                  start=c(base.loc, base.loc+100, base.loc + 250),
                  end=c(base.loc + 50, base.loc+120, base.loc+290),
                  name=c("a", "b", "c"),
                  score=runif(3),
                  strand=rep("*", 3),
                  stringsAsFactors=FALSE)

track <- DataFrameAnnotationTrack("dataframeTest", tbl)
trackSize(track)

}
