% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvAnnotationTrack.R
\docType{class}
\name{igvAnnotationTrack-class}
\alias{igvAnnotationTrack-class}
\alias{.igvAnnotationTrack}
\alias{igvAnnotationTrack}
\title{Constructor for igvAnnotationTrack}
\usage{
igvAnnotationTrack(
  trackName,
  annotation,
  fileFormat = c("bed"),
  color = "gray",
  displayMode = c("SQUISHED", "COLLAPSED", "EXPANDED"),
  sourceType = "file",
  trackHeight = 30,
  expandedRowHeight = 30,
  squishedRowHeight = 15,
  maxRows = 500,
  searchable = FALSE,
  visibilityWindow = 1e+05
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{annotation}{An opague type, currently either a data.frame, GRanges, or UCSCBed object from rtracklayer.}

\item{fileFormat}{Only "bed" is currently supported.}

\item{color}{A CSS color name (e.g., "red" or "#FF0000")}

\item{displayMode}{"COLLAPSED", "EXPANDED", or "SQUISHED"}

\item{sourceType}{Only "file" sources are currently supported.}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{expandedRowHeight}{Height of each row of features in "EXPANDED" mode.}

\item{squishedRowHeight}{Height of each row of features in "SQUISHED" mode, for compact viewing.}

\item{maxRows}{of features to display}

\item{searchable}{If TRUE, labels on annotation elements may be used in search}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
An igvAnnotationTrack object
}
\description{
Constructor for igvAnnotationTrack
}
