% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvR.R
\name{displayTrack,igvR-method}
\alias{displayTrack,igvR-method}
\alias{displayTrack}
\title{display the specified track in igv}
\usage{
\S4method{displayTrack}{igvR}(obj, track, deleteTracksOfSameName = TRUE)
}
\arguments{
\item{obj}{An object of class igvR}

\item{track}{An object of some terminal (leaf) subclass of Track}

\item{deleteTracksOfSameName}{logical, default TRUE}
}
\value{
""
}
\description{
display the specified track in igv
}
\examples{
if(interactive()){
   igv <- igvR()
   setGenome(igv, "hg38")
   showGenomicRegion(igv, "MEF2C")
   base.loc <- 88883100
   tbl <- data.frame(chrom=rep("chr5", 3),
                     start=c(base.loc, base.loc+100, base.loc + 250),
                     end=c(base.loc + 50, base.loc+120, base.loc+290),
                     name=c("a", "b", "c"),
                     score=runif(3),
                     strand=rep("*", 3),
                     stringsAsFactors=FALSE)
   track <- DataFrameAnnotationTrack("dataframeTest", tbl, color="red",
                                      displayMode="EXPANDED")
   showGenomicRegion(igv, "chr5:88,881,962-88,885,045")
   displayTrack(igv, track)
   }
}
