% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCSCBedGraphQuantitativeTrack.R
\docType{class}
\name{UCSCBedGraphQuantitativeTrack-class}
\alias{UCSCBedGraphQuantitativeTrack-class}
\alias{.UCSCBedGraphQuantitativeTrack}
\alias{UCSCBedGraphQuantitativeTrack}
\title{Constructor for UCSCBedGraphQuantitativeTrack}
\usage{
UCSCBedGraphQuantitativeTrack(
  trackName,
  quantitativeData,
  color = "blue",
  trackHeight = 50,
  autoscale = TRUE,
  min = NA_real_,
  max = NA_real_,
  visibilityWindow = 1e+05
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{quantitativeData}{A GRanges object with (at least) a "score" metadata column}

\item{color}{A CSS color name (e.g., "red" or "#FF0000")}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{autoscale}{Autoscale track to maximum value in view}

\item{min}{Sets the minimum value for the data (y-axis) scale. Usually zero.}

\item{max}{Sets the maximum value for the data (y-axis) scale. This value is ignored if autoscale is TRUE}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
A UCSCBedGraphQuantitativeTrack object
}
\description{
\code{UCSCBedGraphQuantitativeTrack} creates an \code{IGV} track for bedGraph objects
imported with \code{rtracklayer}
}
\details{
Detailed description goes here
}
\examples{

bedGraph.filepath <- system.file(package = "rtracklayer", "tests", "test.bedGraph")
gr.bedGraph <- rtracklayer::import(bedGraph.filepath)
track <- UCSCBedGraphQuantitativeTrack("UCSCBedGraphTest", gr.bedGraph)

if(interactive()){
   igv <- igvR()
   setGenome(igv, "hg38")
   setBrowserWindowTitle(igv, "UCSC BedGraph demo")
   displayTrack(igv, track)
   Sys.sleep(1)  # pause before zoomin
   showGenomicRegion(igv, "chr18:59,103,373-59,105,673")
   }

}
