% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicAlignmentTrack.R
\docType{class}
\name{GenomicAlignmentTrack-class}
\alias{GenomicAlignmentTrack-class}
\alias{.GenomicAlignmentTrack}
\alias{GenomicAlignmentTrack}
\title{Constructor for GenomicAlignmentTrack}
\usage{
GenomicAlignmentTrack(
  trackName,
  alignment,
  trackHeight = 50,
  visibilityWindow = 30000,
  color = "gray"
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{alignment}{A GAlignments object}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}

\item{color}{A character string, either a reconized color ("red") or a hex string ("#FF8532")}
}
\value{
A GenomicAlignmentTrack object
}
\description{
\code{GenomicAlignmentTrack} creates and \code{IGV} track for bed-like objects expressed as GRanges
}
\details{
Detailed description goes here
}
\examples{

  bamFile <- system.file(package="igvR", "extdata", "tumor.bam")
  which <- GRanges(seqnames = "21", ranges = IRanges(10400126, 10400326))
  param <- ScanBamParam(which=which, what = scanBamWhat())
  x <- readGAlignments(bamFile, use.names=TRUE, param=param)
  track <- GenomicAlignmentTrack("tumor", x)

}
