% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRangesQuantitativeTrack.R
\docType{class}
\name{GRangesQuantitativeTrack-class}
\alias{GRangesQuantitativeTrack-class}
\alias{.GRangesQuantitativeTrack}
\alias{GRangesQuantitativeTrack}
\title{Constructor for GRangesQuantitativeTrack}
\usage{
GRangesQuantitativeTrack(
  trackName,
  quantitativeData,
  color = "blue",
  trackHeight = 50,
  autoscale = TRUE,
  min = NA_real_,
  max = NA_real_,
  visibilityWindow = 1e+05
)
}
\arguments{
\item{trackName}{A character string, used as track label by igv, we recommend unique names per track.}

\item{quantitativeData}{A GRanges object with (at least) a "score" metadata column}

\item{color}{A CSS color name (e.g., "red" or "#FF0000")}

\item{trackHeight}{track height, typically in range 20 (for annotations) and up to 1000 (for large sample vcf files)}

\item{autoscale}{Autoscale track to maximum value in view}

\item{min}{Sets the minimum value for the data (y-axis) scale. Usually zero.}

\item{max}{Sets the maximum value for the data (y-axis) scale. This value is ignored if autoscale is TRUE}

\item{visibilityWindow}{Maximum window size in base pairs for which indexed annotations or variants are displayed. Defaults: 1 MB for variants, whole chromosome for other track types.}
}
\value{
A GRangesQuantitativeTrack object
}
\description{
\code{GRangesQuantitativeTrack} creates and \code{IGV} track for bed objects imported using \code{rtracklayer}
}
\details{
Detailed description goes here
}
\examples{
base.loc <- 88883100
tbl <- data.frame(chrom=rep("chr5", 3),
                  start=c(base.loc, base.loc+100, base.loc + 250),
                  end=c(base.loc + 50, base.loc+120, base.loc+290),
                  name=c("a", "b", "c"),
                  score=runif(3),
                  strand=rep("*", 3),
                  stringsAsFactors=FALSE)

gr <- GRanges(tbl)
track <- GRangesQuantitativeTrack("GRangesQTest", gr)

}
