% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEE_plug.R
\name{wrapup_for_iSEE}
\alias{wrapup_for_iSEE}
\title{wrapup_for_iSEE}
\usage{
wrapup_for_iSEE(dds, res)
}
\arguments{
\item{dds}{A \code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object.}

\item{res}{A \code{\link[DESeq2:DESeqResults]{DESeq2::DESeqResults()}} object.}
}
\value{
A SummarizedExperiment object, with raw counts, normalized counts, and
variance-stabilizing transformed counts in the assay slots; and with colData
and rowData extracted from the corresponding input parameters
}
\description{
Combine data from a typical DESeq2 run
}
\details{
Combines the DESeqDataSet input and DESeqResults into a SummarizedExperiment
object, which can be readily explored with iSEE.

A typical usage would be after running the DESeq2 pipeline as specified in
one of the workflows which include this package, e.g. in the context of the
ideal package.
}
\examples{
# with simulated data...
library(DESeq2)
dds <- DESeq2::makeExampleDESeqDataSet(n = 10000, m = 8)
dds <- DESeq(dds)
res <- results(dds)
se <- wrapup_for_iSEE(dds, res)
# library(iSEE)
# iSEE(se)
\dontrun{
# or with the well known airway package...
library("airway")
data("airway", package = "airway")
airway
dds_airway <- DESeq2::DESeqDataSetFromMatrix(assay(airway),
  colData = colData(airway),
  design = ~ cell + dex
)
dds_airway <- DESeq2::DESeq(dds_airway)
res_airway <- DESeq2::results(dds_airway)
se_airway <- wrapup_for_iSEE(dds_airway, res_airway)
# iSEE(se_airway)
}
}
