% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitBAM_byRepindex.R
\name{splitBAM_byRepindex}
\alias{splitBAM_byRepindex}
\title{Split the composite BAM file using replicate indexes (MAPCap data)}
\usage{
splitBAM_byRepindex(bamFile, outfile_prefix, ncores = 1)
}
\arguments{
\item{bamFile}{character. Path to a mapped BAM file}

\item{outfile_prefix}{character. prefix for output file (replicates IDs will be added as RR/YY)}

\item{ncores}{integer. Number of cores to use for parallel processing}
}
\value{
Filtered files by replicate Index
}
\description{
Split the composite BAM file using replicate indexes (MAPCap data)
}
\examples{

bam <- system.file("extdata", "bam/embryo1.bam", package = "icetea")
splitBAM_byRepindex(bamFile = bam, outfile_prefix = "testSplit", ncores = 1)

}
