% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotting_functions.R
\name{plotReadStats}
\alias{plotReadStats}
\alias{plotReadStats,CapSet-method}
\title{Plot read statistics from the CapSet object}
\usage{
plotReadStats(
  CSobject,
  plotType = "dodge",
  plotValue = "numbers",
  outFile = NULL
)

\S4method{plotReadStats}{CapSet}(
  CSobject,
  plotType = "dodge",
  plotValue = "numbers",
  outFile = NULL
)
}
\arguments{
\item{CSobject}{The \code{\link{CapSet}} object}

\item{plotType}{character. The type of plot to make. Choose from "stack" or "dodge" for either a stacked barchart,
or a bar chart with "dodged" positions (analogous to ggplot)}

\item{plotValue}{character. What values to plot. Choose from "numbers" or "proportions". If "proportions"
is selected, the proportion of reads w.r.t total demultiplexed reads per sample
would be plotted}

\item{outFile}{character. Output file name. (filename extention would be used to determine type).
If outfile not specified, the plot would be retured on the screen}
}
\value{
A ggplot object, or a file. Plot showing the number/proportion of reads in each category, per sample
}
\description{
Plot read statistics from the CapSet object
}
\examples{

# load a previously saved CapSet object
cs <- exampleCSobject()
plotReadStats(cs, plotType = "dodge", plotValue = "numbers", outFile = "test_numbers.pdf")

}
