% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/detectDiffTSS.R
\name{getNormFactors}
\alias{getNormFactors}
\alias{getNormFactors,CapSet-method}
\title{Calculate normalization factors from CapSet object}
\usage{
getNormFactors(CSobject, features, method = "TMM", ...)

\S4method{getNormFactors}{CapSet}(CSobject, features, method = "TMM", ...)
}
\arguments{
\item{CSobject}{An object of class \code{\link{CapSet}}}

\item{features}{A \link[GenomicRanges]{GRanges-class}.object to count the reads on.}

\item{method}{Method to use for normalization. Options : "TMM","RLE","upperquartile","none"}

\item{...}{Additional arguments passed to \link[edgeR]{calcNormFactors}}
}
\value{
Numeric vector of calculated normalization factors.
}
\description{
Calculate normalization factors from CapSet object
}
\examples{

 # load a txdb object
 library("TxDb.Dmelanogaster.UCSC.dm6.ensGene")
 library(GenomeInfoDb)  # for seqlevelsStyle()
 seqlevelsStyle(TxDb.Dmelanogaster.UCSC.dm6.ensGene) <- "ENSEMBL"

 # get genes (only X chromsome, for simplicity)
 seqlevels(TxDb.Dmelanogaster.UCSC.dm6.ensGene) <- "X"
 dm6genes <- genes(TxDb.Dmelanogaster.UCSC.dm6.ensGene)

# get norm factors by counting reads on genes
cs <- exampleCSobject()
normfacs <- getNormFactors(cs, dm6genes, method = "RLE")

}
