% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getGeneCounts.R
\name{getGeneCounts}
\alias{getGeneCounts}
\alias{getGeneCounts,CapSet-method}
\title{Get gene-level counts from TSS data}
\usage{
getGeneCounts(
  CSobject,
  transcriptGRL,
  regionAroundTSS = 500,
  outfile = NA,
  ncores = 1
)

\S4method{getGeneCounts}{CapSet}(
  CSobject,
  transcriptGRL,
  regionAroundTSS = 500,
  outfile = NA,
  ncores = 1
)
}
\arguments{
\item{CSobject}{The \code{\link{CapSet}} object to use.}

\item{transcriptGRL}{A GRangesList object containing transcripts, created using transcriptsBy(txdb)}

\item{regionAroundTSS}{integer, indicating how many bases downstream of TSS to count}

\item{outfile}{character. Tab-separated output file name (if required)}

\item{ncores}{integer. No. of cores/threads to use}
}
\value{
data.frame with gene-level counts for all genes in the txdb object
}
\description{
Get gene-level counts from TSS data
}
\examples{

 # load a txdb object
 library("TxDb.Dmelanogaster.UCSC.dm6.ensGene")
 library(GenomeInfoDb)  # for seqlevelsStyle()
 seqlevelsStyle(TxDb.Dmelanogaster.UCSC.dm6.ensGene) <- "ENSEMBL"

 # get transcripts by gene (only X chromsome, for simplicity)
 seqlevels(TxDb.Dmelanogaster.UCSC.dm6.ensGene) <- "X"
 dm6trans <- transcriptsBy(TxDb.Dmelanogaster.UCSC.dm6.ensGene, "gene")

 # load a CapSet object
 cs <- exampleCSobject()
 # get gene counts, counting reads around 500 bp of the TSS
 gcounts <- getGeneCounts(cs, dm6trans)

}
