% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeReducedDim.R
\name{modeReducedDim}
\alias{modeReducedDim}
\title{App pre-configured to compare multiple reduced dimension plots}
\usage{
modeReducedDim(
  se,
  includeNames = reducedDimNames(se),
  colorBy = NULL,
  ...,
  plotWidth = NULL
)
}
\arguments{
\item{se}{An object that coercible to \linkS4class{SingleCellExperiment}}

\item{includeNames}{Character vector with the names of reduced dimensions
to display as individual panels. The default uses all available in
\code{reducedDimNames(se)}.}

\item{colorBy}{Character scalar controlling coloring of cells. Must match either
to one of \code{colnames(colData(se))} or \code{rownames(se)}. If coloring
by a colData column, a column data plot is opened in addition to the
reduced dimension panels. If coloring by a feature, a row statistics table
is openend in addition to the reduced dimension panels, from which the
latter are receiving the color.}

\item{...}{Additional arguments passed to \code{\link{iSEE}}.}

\item{plotWidth}{The grid width of linked plots (numeric vector of length
either 1 or equal to \code{length(includeNames)}). The total width of
the window is 12, so \code{plotWidth = 4} for example will show three
panels per row. If \code{plotWidth = NULL} (the default), a value will be
estimated depending on the number of reduced dimension panels.}
}
\value{
A Shiny app object is returned.
}
\description{
This mode launches a Shiny App preconfigured with multiple linked reduced
dimension plots for interactive data exploration of the
\code{\link{SingleCellExperiment}} object.
}
\examples{
library(scRNAseq)

# Example data ----
sce <- ReprocessedAllenData(assays="tophat_counts")
class(sce)

library(scater)
sce <- logNormCounts(sce, exprs_values="tophat_counts")
sce <- runPCA(sce, ncomponents = 30)
sce <- runTSNE(sce)
sce <- runUMAP(sce)
reducedDimNames(sce)

# launch the app ----
# ... coloring by a column data variable
app <- modeReducedDim(sce, colorBy = "Primary.Type")
if (interactive()) {
    shiny::runApp(app, port=1234)
}
# ... coloring by a feature
app <- modeReducedDim(sce, colorBy = "Scnn1a")
if (interactive()) {
    shiny::runApp(app, port=1234)
}
}
