% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeEmpty.R
\name{modeEmpty}
\alias{modeEmpty}
\title{App pre-configured to launch with no visible panel}
\usage{
modeEmpty(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[=iSEE]{iSEE()}}.}
}
\value{
A Shiny app object is returned.
}
\description{
This mode launches an app that does not display any panel.
}
\details{
This mode presents the advantage to launch an interface in a minimal amount of time,
as it does not need to render any panel when the interface is launched.
Users can then use the \code{"Organize panels"} widget to select panels to display in the interface.
}
\examples{
example("SingleCellExperiment")
rownames(sce) <- paste0("G", 1:200)
colnames(sce) <- paste0("C", 1:100)

app <- modeEmpty(sce)
if (interactive()) {
  shiny::runApp(app, port=1234)
}

}
