% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utils}
\alias{utils}
\alias{.check_all_panels}
\alias{.check_panel}
\title{iSEEtree utils}
\usage{
.check_all_panels(se, initial)

.check_panel(se, initial, panel.class, panel.fun, wtext)
}
\arguments{
\item{se}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}

\item{initial}{\code{Panel vector}. A list of panel objects to check.}

\item{panel.class}{\code{Character vector}. A list of panel names
corresponding to panel objects in \code{initial}.}

\item{panel.fun}{\code{Function scalar}. The element of \code{se} whose
existence should be checked.}

\item{wtext}{\code{Character scalar}. Text of the warning message returned
if \code{panel.fun} does not exist or is empty.}
}
\value{
\code{.check_panel} returns the input \code{initial} list of panels excluding
the checked panel if \code{panel.fun} is \code{NULL} or empty.
\code{.check_all_panels} applies \code{.check_panel} to multiple panels and
returns the a filtered version of \code{initial}.
}
\description{
Utility functions to check the existence of specific elements in a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
that are compulsory when using certain panels.
}
\examples{
# Import libraries
library(mia)
library(TreeSummarizedExperiment)

# Import TreeSE
data("Tengeler2020", package = "mia")
tse <- Tengeler2020

# Create list of panels
initial <- c(RowTreePlot(), ColumnTreePlot())
# If RowTreePlot is in initial, check whether rowLinks is defined
initial <- .check_panel(tse, initial, "RowTreePlot", rowLinks)
# If ColumnTreePlot is in initial, check whether colLinks is defined
initial <- .check_panel(tse, initial, "ColumnTreePlot", colLinks)

# View filtered list of panels
initial

}
\keyword{internal}
