% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/family-TreePlot.R
\docType{class}
\name{TreePlot-class}
\alias{TreePlot-class}
\alias{TreePlot}
\title{Tree plot}
\description{
The TreePlot is a virtual class that creates a hierarchical tree of either
the features or samples of a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
object. The \linkS4class{RowTreePlot} and \linkS4class{ColumnTreePlot}
classes belong to this family and are specialised to visualise the rowTree
and the colTree, respectively.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualisation:
\itemize{
\item \code{layout}: \code{Character scalar}. Tree layout.
(Default: \code{"fan"})
\item \code{add.legend}: \code{Logical scalar}. Should legend be shown.
(Default: \code{TRUE})
\item \code{edge.colour.by}: \code{Character scalar}. Parameter to colour
lines by when \code{colour_parameters = "Edge"}. (Default: \code{NULL})
\item \code{edge.size.by}: \code{Character scalar}. Parameter to size lines
by when \code{size_parameters = "Edge"}. (Default: \code{NULL})
\item \code{tip.colour.by}: \code{Character scalar}. Parameter to colour tips
by when \code{colour_parameters = "Tip"}. (Default: \code{NULL})
\item \code{tip.size.by}: \code{Character scalar}. Parameter to size tips by
when \code{size_parameters = "Tip"}. (Default: \code{NULL})
\item \code{tip.shape.by}: \code{Character scalar}. Parameter to shape tips
by when \code{shape_parameters = "Tip"}. (Default: \code{NULL})
\item \code{node.colour.by}: \code{Character scalar}. Parameter to colour
nodes by when \code{colour_parameters = "Node"}. (Default: \code{NULL})
\item \code{node.size.by}: \code{Character scalar}. Parameter to size nodes
by when \code{size_parameters = "Node"}. (Default: \code{NULL})
\item \code{node.shape.by}: \code{Character scalar}. Parameter to shape nodes
by when \code{shape_parameters = "Node"}. (Default: \code{NULL})
\item \code{order.tree}: \code{Logical scalar}. Should the tree be ordered
alphabetically by the taxonomic levels. (Default: \code{FALSE})
\item \code{open.angle}: \code{Numeric scalar}. Angle by which the tree is
opened when \code{layout} is \code{"fan"}. (Default: \code{0})
\item \code{rotate.angle}: \code{Numeric scalar}. Angle by which the tree is
rotated. (Default: \code{0})
\item \code{branch.length}: \code{Logical scalar}. Should branch length be
equalised. (Default: \code{FALSE})
}

In addition, this class inherits all slots from its parent
\code{\link[iSEE:Panel-class]{Panel}}.
}

\seealso{
\linkS4class{RowTreePlot}
\linkS4class{ColumnTreePlot}
}
\author{
Giulio Benedetti
}
