% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/class-RDAPlot.R
\docType{class}
\name{RDAPlot-class}
\alias{RDAPlot-class}
\alias{RDAPlot}
\title{RDA plot}
\value{
The \code{RDAPlot(...)} constructor creates an instance of a RDAPlot class,
where any slot and its value can be passed to \code{...} as a named argument.
}
\description{
CCA/RDA plot for the rows of a
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-constructor]{TreeSummarizedExperiment}}
object. The reduced dimension can be produced with \code{\link[mia:runCCA]{runRDA}}
and gets stored in the \code{\link[SingleCellExperiment:reducedDims]{reducedDim}}
slot of the experiment object. The panel implements \code{\link[miaViz:plotCCA]{plotRDA}}
to generate the plot.
}
\section{Slot overview}{

The following slots control the thresholds used in the visualisation:
\itemize{
\item \code{add.ellipse}, a string specifying ellipse layout (filled, coloured or absent).
\item \code{colour_by}, a string specifying the parameter to color by.
\item \code{add.vectors}, a logical indicating if vectors should appear in the plot.
\item \code{vec.text}, a logical indicating if text should be encased in a box.
\item \code{confidence.level}, a numeric between 0 and 1 to adjust confidence level.
\item \code{ellipse.alpha}, a numeric between 0 and 1 t o adjust ellipse opacity.
\item \code{ellipse.linewidth}, a numeric specifying the size of ellipses.
\item \code{ellipse.linetype}, a numeric specifying the style of ellipses.
\item \code{vec.size}, a numeric specifying the size of vectors.
\item \code{vec.colour}, a string specifying the colour of vectors.
\item \code{vec.linetype}, a numeric specifying the style of vector lines.
\item \code{arrow.size}, a numeric specifying the size of arrows.
\item \code{label.colour}, a string specifying the colour of text and labels.
\item \code{label.size}, a numeric specifying the size of text and labels.
\item \code{add.significance}, a logical indicating if variance and p-value
should appear in the labels.
\item \code{add.expl.var}, a logical indicating if variance should appear
on the coordinate axes.
}

In addition, this class inherits all slots from its parent class
\code{\link[iSEE:Panel-class]{Panel}}.
}

\examples{
# Import TreeSE
library(mia)
data("enterotype", package = "mia")
tse <- enterotype

# Run RDA and store results into TreeSE
tse <- addRDA(tse, assay.type = "counts",
              formula = assay ~ ClinicalStatus + Gender + Age,
              FUN = vegan::vegdist,
              distance = "bray",
              na.action = na.exclude)

# Store panel into object
panel <- RDAPlot()
# View some adjustable parameters
head(slotNames(panel))

# Launch iSEE with custom initial panel
if (interactive()) {
  iSEE(tse, initial = c(panel))
}

}
\author{
Giulio Benedetti
}
