% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEindexResource-class.R
\name{iSEEindexRcallResource-class}
\alias{iSEEindexRcallResource-class}
\alias{precache,iSEEindexRcallResource-method}
\alias{iSEEindexRcallResource}
\title{The iSEEindexRcallResource class}
\usage{
iSEEindexRcallResource(x)
}
\arguments{
\item{x}{List of metadata. See Details.}
}
\value{
The constructor function \code{iSEEindexRcallResource()} returns an object
of object of class \code{iSEEindexRcallResource}.
}
\description{
The iSEEindexRcallResource class represents a resource accessible through
the result of an R call.
A URI for this type of resource uses the prefix \dQuote{rcall://}.
}
\details{
Required metadata:

\describe{
\item{uri}{Character scalar. R call which, once evaluated, produces a
character scalar that is the URI of the resource.}
}
}
\section{URI format}{

The URI must contain valid R code, once the prefix \verb{rcall://} is removed.
The code must return the path to an existing file on the local filesystem.

For instance:

\if{html}{\out{<div class="sourceCode">}}\preformatted{rcall://system.file(package='iSEEindex','ReprocessedAllenData_config_01.R')
}\if{html}{\out{</div>}}
}

\section{Slot overview}{

This class inherits all slots from its parent class
\linkS4class{iSEEindexResource}.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a
\linkS4class{iSEEindexRcallResource} class.
Refer to the documentation for each method for more details on the remaining
arguments.

\itemize{
\item \code{\link{precache}(x, ...)} trims the \verb{rcall://} prefix,
evaluates the remainder of the URI as R code, and caches a copy of the
resource located at the resulting file path using \pkg{BiocFileCache},
before returning the file path to the cached file.
}
}

\examples{
iSEEindexRcallResource(list(
  uri = "rcall://system.file(package='iSEEindex','ReprocessedAllenData_config_01.R')"
))
}
\author{
Kevin Rue-Albrecht
}
