% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{plot-generics}
\alias{plot-generics}
\alias{.generateDotPlotData}
\alias{.generateDotPlot}
\alias{.prioritizeDotPlotData}
\alias{.colorByNoneDotPlotField}
\alias{.colorByNoneDotPlotScale}
\title{Generics for DotPlot plotting}
\description{
A series of generics for controlling how plotting is performed in \linkS4class{DotPlot} panels.
\linkS4class{DotPlot} subclasses can specialize one or more of them to modify the behavior of \code{\link{.generateOutput}}.
}
\section{Generating plotting data}{

\code{.generateDotPlotData(x, envir)} sets up the data to use in the \linkS4class{DotPlot} plot.
The following arguments are required:
\itemize{
\item \code{x}, an instance of a \linkS4class{DotPlot} subclass.
\item \code{envir}, the evaluation environment in which the data.frame is to be constructed.
This can be assumed to have \code{se}, the \linkS4class{SummarizedExperiment} object containing the current dataset;
possibly \code{col_selected}, if a multiple column selection is being transmitted to \code{x};
and possibly \code{row_selected}, if a multiple row selection is being transmitted to \code{x}.
}

A method for this generic should add a \code{plot.data} variable in \code{envir} containing a data.frame with columns named \code{"X"} and \code{"Y"}, denoting the variables to show on the x- and y-axes respectively.
It should return a list with \code{commands}, a character vector of commands that produces \code{plot.data} when evaluated in \code{envir};
and \code{labels}, a list of strings containing labels for the x-axis (named \code{"X"}), y-axis (\code{"Y"}) and plot (\code{"title"}).

Each row of the \code{plot.data} data.frame should correspond to one row or column in the SummarizedExperiment \code{envir$se} for \linkS4class{RowDotPlot}s and \linkS4class{ColumnDotPlot}s respectively.
Note that, even if only a subset of rows/columns in the SummarizedExperiment are to be shown, there must always be one row in the data.frame per row/column of the SummarizedExperiment, and in the same order.
All other rows of the data.frame should be filled in with \code{NA}s rather than omitted entirely.
This is necessary for correct interactions with later methods that add other variables to \code{plot.data}.

Any internal variables that are generated by the commands in \code{commands} should be prefixed with \code{.} to avoid potential clashes with reserved variable names in the rest of the application.

This generic is called by \code{.generateDotPlot} (see below), which is in turn called by \code{\link{.generateOutput}}.
The idea is that developers can specialize \code{.generateDotPlotData} to change the data source for a DotPlot subclass without needing to reimplement the entirety of \code{.generateDotPlot}.
}

\section{Generating the ggplot object}{

\code{.generateDotPlot(x, labels, envir)} creates the plot to be shown in the interface.
The following arguments are required:
\itemize{
\item \code{x}, an instance of a \linkS4class{DotPlot} subclass.
\item \code{labels}, a list of labels corresponding to the columns of \code{plot.data}.
This is typically used to define axis or legend labels in the plot.
\item \code{envir}, the evaluation environment in which the \link{ggplot} object is to be constructed.
This can be assumed to have \code{plot.data}, a data.frame of plotting data.

Note that \code{se}, \code{row_selected} and \code{col_selected} will still be present in \code{envir},
but it is simplest to only use information that has already been incorporated into \code{plot.data} where possible.
This is because the order and number of rows in \code{plot.data} may have changed since \code{\link{.generateDotPlotData}}.
}

Methods for this generic should return a list with \code{plot}, a \link{ggplot} object;
and \code{commands}, a character vector of commands to produce that object when evaluated inside \code{envir}.
This plot will subsequently be the rendered output in \code{\link{.renderOutput}}.
Note that \code{envir} should contain a copy of the \code{plot} object in a variable named \code{dot.plot} -
see below for details.

Methods are expected to respond to the presence of various fields in the \code{plot.data}.
The data.frame will contain, at the very least, the fields \code{"X"} and \code{"Y"} from \code{\link{.generateDotPlotData}}.
Depending on the parameters of \code{x}, it may also have the following columns:
\itemize{
\item \code{"ColorBy"}, the values of the covariate to use to color each point.
\item \code{"ShapeBy"}, the values of the covariate to use for shaping each point.
This is guaranteed to be categorical.
\item \code{"SizeBy"}, the values of the covariate to use for sizing each point.
This is guaranteed to be continuous.
\item \code{"FacetRow"}, the values of the covariate to use to create row facets.
This is guaranteed to be categorical.
\item \code{"FacetColumn"}, the values of the covariate to use to create column facets.
This is guaranteed to be categorical.
\item \code{"SelectBy"}, a logical field indicating whether the point was included in a multiple selection
(i.e., transmitted from another plot with \code{x} as the receiver).
Note that if \code{RowSelectionRestrict=TRUE} or \code{ColumnSelectionRestrict=TRUE} 
(for \linkS4class{RowDotPlot}s and \linkS4class{ColumnDotPlot}s, respectively),
\code{plot.data} will already have been subsetted to only retain \code{TRUE} values of this field.
}

\code{envir} may also contain the following variables:
\itemize{
\item \code{plot.data.all}, present when a multiple selection is transmitted to \code{x} and \code{RowSelectionRestrict=TRUE} or \code{ColumnSelectionRestrict=TRUE} (for \linkS4class{RowDotPlot}s and \linkS4class{ColumnDotPlot}s, respectively).
This is a data.frame that contains all points prior to subsetting and is useful for defining the boundaries of the plot such that they do not change when the transmitted multiple selection changes.
\item \code{plot.data.pre}, present when downsampling is turned on.
This is a data.frame that contains all points prior to downsampling (but after subsetting, if that was performed) and is again mainly used to fix the boundaries of the plot.
}

Developers may wish to use the \code{\link{.addMultiSelectionPlotCommands}} utility to draw brushes and lassos of \code{x}.
Note that this refers to the brushes and lassos made on \code{x} itself, not those transmitted from another panel to \code{x}.

It would be very unwise for methods to alter the x-axis, y-axis or faceting values in \code{plot.data}.
This will lead to unintuitive discrepancies between apparent visual selections for a brush/lasso and the actual multiple selection that is evaluated by downstream functions like \code{\link{.processMultiSelections}}.

In certain situations, a \linkS4class{DotPlot} subclass may be able to build off a \link{ggplot} generated by its parent class.
This is easily done by exploiting the fact that methods for this generic are expected to store a copy of their \code{plot} \link{ggplot} object as a \code{dot.plot} variable in \code{envir}.
A specialized method for the subclass can \code{\link{callNextMethod}()} to populate \code{envir} with the initial \code{dot.plot}, and then just construct and execute commands to add more \pkg{ggplot2} layers as desired.

This generic is called by \code{.generateOutput} for DotPlot subclasses.
Again, the idea here is that developers can specialize \code{.generateDotPlot} to change the plot aesthetics without needing to reimplement the entirety of \code{.generateOutput}.
}

\section{Prioritizing points}{

\code{.prioritizeDotPlotData(x, envir)} specifies the \dQuote{priority} of points to be plotted, where high-priority points are plotted last so that they will not be masked by other points.
The following arguments are required:
\itemize{
\item \code{x}, an instance of a \linkS4class{DotPlot} subclass.
\item \code{envir}, the evaluation environment in which the \link{ggplot} object is to be constructed.
This can be assumed to have \code{plot.data}, a data.frame of plotting data.

Again, note that \code{se}, \code{row_selected} and \code{col_selected} will still be present in \code{envir}, but it is simplest to only use information that has already been incorporated into \code{plot.data} where possible.
This is because the order and number of rows in \code{plot.data} may have changed since \code{\link{.generateDotPlotData}}.
}

Methods for this generic are expected to generate a \code{.priority} variable in \code{envir}, an ordered factor of length equal to \code{nrow(plot.data)} indicating the priority of each point.
They may also generate a \code{.rescaled} variable, a named numeric vector containing the scaling factor to apply to the downsampling resolution for each level of \code{.priority}.

The method itself should return a list containing \code{commands}, a character vector of R commands required to generate these variables;
and \code{rescaled}, a logical scalar indicating whether a \code{.rescaled} variable was produced.

Points assigned the highest level in \code{.priority} are regarded as having the highest visual importance.
Such points will be shown on top of other points if there are overlaps on the plot, allowing developers to specify that, e.g., DE genes should be shown on top of non-DE genes.
Scaling of the resolution enables developers to perform more aggressive downsampling for unimportant points.

Methods for this generic may also return \code{NULL}, in which case no special action is taken.

This generic is called by \code{.generateDotPlot}, which is in turn called by \code{\link{.generateOutput}}.
Thus, developers of DotPlot subclasses can specialize this generic to change the point priority without needing to reimplement the entirety of \code{.generateDotPlot}.
}

\section{Controlling the \dQuote{None} color scale}{

In some cases, it is desirable to insert a default scale when \code{ColorBy="None"}.
This is useful for highlighting points in a manner that is integral to the nature of the plot, e.g., up- or down-regulated genes in a MA plot.
We provide a few generics to help control which points are highlighted and how they are colored.

\code{.colorByNoneDotPlotField(x)} expects \code{x}, an instance of a \linkS4class{DotPlot} subclass, and returns a string containing a name of a column in \code{plot.data} to use for coloring in the \code{ggplot} mapping.
This assumes that the relevant field was added to \code{plot.data} by a method for \code{\link{.generateDotPlotData}}.

\code{.colorByNoneDotPlotScale(x)} expects \code{x}, an instance of a \linkS4class{DotPlot} subclass, and returns a string containing a \pkg{ggplot2} \code{scale_color_*} call, e.g., \code{\link{scale_color_manual}}.
This string should end with a \code{"+"} operator as additional \pkg{ggplot2} layers will be added by \pkg{iSEE}.

This generic is called by \code{.generateDotPlot}, which is in turn called by \code{\link{.generateOutput}}.
Thus, developers of DotPlot subclasses can specialize this generic to change the default color scheme without needing to reimplement the entirety of \code{.generateDotPlot}.
}

\author{
Kevin \dQuote{K-pop} Rue-Albrecht, Aaron \dQuote{A-bomb} Lun
}
