% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/utils_colors.R
\name{.panelColor}
\alias{.panelColor}
\alias{.getPanelColor}
\title{Get panel colors}
\usage{
.panelColor(x)

.getPanelColor(x)
}
\arguments{
\item{x}{An instance of a \linkS4class{Panel} class.}
}
\value{
A string containing the color assigned to the class of \code{x}.
}
\description{
Functions to get/set panel colors at the user and developer level.
This determines the color of the panel header as well as (for \linkS4class{DotPlot}s) the color and fill of the brush.
}
\details{
For developers: \code{.panelColor} is a method that should be subclassed for each \linkS4class{Panel} subclass.
This determines the color theme for all instances of that class for use in, e.g., headers and box shadings.
Developers should choose a color that is dark enough to serve as a background for white text. 
We recommend defining colors as hex color codes for full compatibility with both HTML elements and R plots.

For users: by default, \code{.getPanelColor} will return the default color of each panel as specified by the developer in \code{.panelColor}.
However, users can override this by setting the \code{panel.color} global option to a named character vector of colors (see Examples).
This can be used to customize the color scheme for any given call to \code{\link{iSEE}}.
The names of the vector should be set to the name of class to be overridden; if a class is not named here, its default color is used.
}
\examples{
rdp <- ReducedDimensionPlot()

# Default color, as specified by the developer:
.panelColor(rdp)

# Still the default color:
.getPanelColor(rdp)

# Overriding the default colors:
sce <- SingleCellExperiment(list(logcounts=matrix(rnorm(1000), ncol=100)))
reducedDim(sce, "PCA") <- matrix(runif(200), ncol=2)

sce <- registerAppOptions(sce, panel.color=c(ReducedDimensionPlot="#1e90ff"))
if (interactive()) {
    iSEE(sce, initial=list(rdp))
}

}
\author{
Aaron Lun
}
