% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_class.R
\name{class-utils}
\alias{class-utils}
\alias{.emptyDefault}
\title{Set default slot values}
\usage{
.emptyDefault(args, field, default)
}
\arguments{
\item{args}{A named list of arguments to pass to the \code{initialize} method for a given class.}

\item{field}{String specifying the field to set.}

\item{default}{The default value of the slot in \code{field}.}
}
\value{
\code{args} is returned with the named \code{field} set to \code{default} if it was previously absent.
}
\description{
A utility function to set slots to default values if their values are not provided to \code{\link{initialize}} methods.
}
\details{
A more natural approach would be to have the default values in the arguments of the \code{initialize} method.
However, this would require us to hard-code the slot names in the function signature,
which would break our current DRY model of only specifying the slot names once.
}
\examples{
showMethods("initialize", classes = "ReducedDimensionPlot", includeDefs = TRUE)
}
\author{
Aaron Lun, Kevin Rue-Albrecht
}
