% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_RowDataPlot.R
\docType{methods}
\name{RowDataPlot-class}
\alias{RowDataPlot-class}
\alias{RowDataPlot}
\alias{initialize,RowDataPlot-method}
\alias{.refineParameters,RowDataPlot-method}
\alias{.defineDataInterface,RowDataPlot-method}
\alias{.createObservers,RowDataPlot-method}
\alias{.fullName,RowDataPlot-method}
\alias{.panelColor,RowDataPlot-method}
\alias{.multiSelectionInvalidated,RowDataPlot-method}
\alias{.generateDotPlotData,RowDataPlot-method}
\alias{.allowableXAxisChoices,RowDataPlot-method}
\alias{.allowableYAxisChoices,RowDataPlot-method}
\alias{.definePanelTour,RowDataPlot-method}
\title{The RowDataPlot panel}
\description{
The RowDataPlot is a panel class for creating a \linkS4class{RowDotPlot} where the y-axis represents a variable from the \code{\link{rowData}} of a \linkS4class{SummarizedExperiment} object.
It provides slots and methods for specifying which variable to use on the y-axis (and, optionally, also the x-axis), as well as a method to create the data.frame in preparation for plotting.
}
\section{Slot overview}{

The following slots control the variables to be shown:
\itemize{
\item \code{YAxis}, a string specifying the row of the \code{\link{rowData}} to show on the y-axis.
If \code{NA}, defaults to the first valid field (see \code{?"\link{.refineParameters,RowDotPlot-method}"}).
\item \code{XAxis}, string specifying what should be plotting on the x-axis.
This can be any one of \code{"None"}, \code{"Row data"} and \code{"Row selection"}.
Defaults to \code{"None"}.
\item \code{XAxisRowData}, string specifying the row of the \code{\link{rowData}} to show on the x-axis.
If \code{NA}, defaults to the first valid field.
}

In addition, this class inherits all slots from its parent \linkS4class{RowDotPlot}, \linkS4class{DotPlot} and \linkS4class{Panel} classes.
}

\section{Constructor}{

\code{RowDataPlot(...)} creates an instance of a RowDataPlot class, where any slot and its value can be passed to \code{...} as a named argument.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{RowDataPlot} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.refineParameters}(x, se)} returns \code{x} after replacing any \code{NA} value in \code{YAxis} or \code{XAxisRowData} with the name of the first valid \code{\link{rowData}} variable.
This will also call the equivalent \linkS4class{RowDotPlot} method for further refinements to \code{x}.
If no valid row metadata variables are available, \code{NULL} is returned instead.
}

For defining the interface:
\itemize{
\item \code{\link{.defineDataInterface}(x, se, select_info)} returns a list of interface elements for manipulating all slots described above.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
\item \code{\link{.allowableXAxisChoices}(x, se)} returns a character vector specifying the acceptable variables in \code{\link{rowData}(se)} that can be used as choices for the x-axis. 
This consists of all variables with atomic values.
\item \code{\link{.allowableYAxisChoices}(x, se)} returns a character vector specifying the acceptable variables in \code{\link{rowData}(se)} that can be used as choices for the y-axis. 
This consists of all variables with atomic values.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all slots described above and in the parent classes.
This will also call the equivalent \linkS4class{RowDotPlot} method.
}

For controlling selections:
\itemize{
\item \code{\link{.multiSelectionInvalidated}(x)} returns \code{TRUE} if the x-axis uses multiple row selections,
such that the point coordinates may change upon updates to upstream selections in transmitting panels.
Otherwise, it dispatches to the \linkS4class{RowDotPlot} method.
}

For defining the panel name:
\itemize{
\item \code{\link{.fullName}(x)} will return \code{"Row data plot"}.
}

For creating the plot:
\itemize{
\item \code{\link{.generateDotPlotData}(x, envir)} will create a data.frame of row metadata variables in \code{envir}.
It will return the commands required to do so as well as a list of labels.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing a panel-specific tour.
}
}

\section{Subclass expectations}{

Subclasses do not have to provide any methods, as this is a concrete class.
}

\examples{
#################
# For end-users #
#################

x <- RowDataPlot()
x[["XAxis"]]
x[["XAxis"]] <- "Row data"

##################
# For developers #
##################

library(scater)
sce <- mockSCE()
sce <- logNormCounts(sce)

# Spits out a NULL and a warning if is nothing to plot.
sce0 <- .cacheCommonInfo(x, sce)
.refineParameters(x, sce0)

# Replaces the default with something sensible.
rowData(sce)$Stuff <- runif(nrow(sce))
sce0 <- .cacheCommonInfo(x, sce)
.refineParameters(x, sce0)

}
\seealso{
\linkS4class{RowDotPlot}, for the immediate parent class.
}
\author{
Aaron Lun
}
