% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iES_plots.R
\name{iES_survPlot}
\alias{iES_survPlot}
\title{iES survival for a certain pathway}
\usage{
iES_survPlot(iES_mat, cli, gs_str, indVec = NULL, npatsThre = 5, title = TRUE)
}
\arguments{
\item{iES_mat, gs_str}{is the GSDB iES_mat with tumor and normal and gs name.}

\item{cli}{clinical data corresponding to the expression data.}

\item{indVec}{the binary indicator for normal(0) and tumor (1) patients.}

\item{npatsThre}{the threshold of number of patients for survival analysis.}

\item{title}{boolean true or false for including the title (gs_str) in the ggplot.}
}
\value{
ggplot object containing the KM plot.
}
\description{
This function allows you to express your love of cats.
}
\examples{
data(PRAD_data)
data(GSDB_example)
iES_mat = iES_cal2(prad_exprs, GSDB = GSDB_example)
iES_survPlot(iES_mat, cli = prad_cli, gs_str = "SimPathway1", indVec = prad_inds)
}
\keyword{and}
\keyword{densityfall}
\keyword{for}
\keyword{normal}
\keyword{plot}
\keyword{sample}
\keyword{tumor}
