% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctLoadData.R
\name{fctLoadData}
\alias{fctLoadData}
\title{fctLoadData}
\usage{
fctLoadData(expressionMat = expressionMat)
}
\arguments{
\item{expressionMat}{A feature matrix (e.g., gene expression) with samples in rows and features (e.g., genes) in columns. Row names must be unique.}
}
\value{
A prepossessed data matrix.
}
\description{
A function to load and preprocess the expression data.
}
\examples{
# Simulated expression matrix with missing values
set.seed(123)
mat <- matrix(rnorm(1000), nrow = 10, ncol = 100)
colnames(mat) <- paste0("Gene", 1:100)
rownames(mat) <- paste0("Sample", 1:10)
mat[sample(length(mat), 50)] <- NA  # introduce some NAs

# Add a Feature_ID column to mimic expected input
expressionMat <- cbind(Feature_ID = paste0("F", 1:10), mat)
expressionMat <- as.data.frame(expressionMat)

# Convert Feature_ID to character (if needed)
expressionMat$Feature_ID <- as.character(expressionMat$Feature_ID)

# Run the function
processed_data <- fctLoadData(expressionMat)

}
