% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fctHierarchicalCluster.R
\name{fctHierarchicalCluster}
\alias{fctHierarchicalCluster}
\title{fctHierarchicalCluster}
\usage{
fctHierarchicalCluster(parcorMat, tom = TRUE, minModuleSize = 10)
}
\arguments{
\item{parcorMat}{A partial correlation matrix from glassoFast$wi: Estimated inverse covariance matrix}

\item{tom}{TRUE: topological overlap measure; FALSE: partial correlation matrix; default is TRUE.}

\item{minModuleSize}{Smallest modules to be generated; default is 10}
}
\value{
result_list List containing TOM_diss (TOM dissimilarity; NA if argument TOM = FALSE), hclustTree (hierarchical clustering object), dynamicMods (index of module membership for features), and mod_count (number of modules).
}
\description{
Perform hierarchical clustering of a partial correlation matrix. By default uses the topological overlap measure (TOM)
}
\examples{
# Simulate a small partial correlation matrix
set.seed(123)
mat <- matrix(rnorm(100), nrow = 10)
colnames(mat) <- paste0("Gene", 1:10)
rownames(mat) <- paste0("Sample", 1:10)

# Compute covariance and partial correlation matrix
cov_mat <- cov(mat)
parcorMat <- glassoFast::glassoFast(cov_mat, rho = 0.25)$wi
diag(parcorMat) <- NA
colnames(parcorMat) <- rownames(parcorMat) <- paste0("Gene", 1:10)

# Run hierarchical clustering
result <- fctHierarchicalCluster(parcorMat, tom = TRUE, minModuleSize = 3)

# View module assignments
head(result$cluster_assignments)

}
