% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fpc}
\alias{fpc}
\alias{fpc<-}
\alias{fpc,COBRAPerformance-method}
\alias{fpc<-,COBRAPerformance,data.frame-method}
\alias{fpc,COBRAPlot-method}
\alias{fpc<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fpc} slot}
\usage{
fpc(x, ...)

fpc(x, ...) <- value

\S4method{fpc}{COBRAPerformance}(x)

\S4method{fpc}{COBRAPerformance,data.frame}(x) <- value

\S4method{fpc}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information necessary to generate false
positive curves for each method and each stratification level.}
}
\value{
The accessor function returns a data frame giving information
  necessary to generate false positive curves for each method and each
  stratification level.
}
\description{
Accessor and replacement functions for the \code{fpc} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status", aspects = "fpc")
head(fpc(cobraperf))
}
\author{
Charlotte Soneson
}
