% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{fdrnbrcurve}
\alias{fdrnbrcurve}
\alias{fdrnbrcurve<-}
\alias{fdrnbrcurve,COBRAPerformance-method}
\alias{fdrnbrcurve<-,COBRAPerformance,data.frame-method}
\alias{fdrnbrcurve,COBRAPlot-method}
\alias{fdrnbrcurve<-,COBRAPlot,data.frame-method}
\title{Accessor and replacement functions for \code{fdrnbrcurve} slot}
\usage{
fdrnbrcurve(x, ...)

fdrnbrcurve(x, ...) <- value

\S4method{fdrnbrcurve}{COBRAPerformance}(x)

\S4method{fdrnbrcurve}{COBRAPerformance,data.frame}(x) <- value

\S4method{fdrnbrcurve}{COBRAPlot,data.frame}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A data frame giving information necessary to generate curves of
observed FDR vs number of features called positive for each method and each
stratification level.}
}
\value{
The accessor function returns a data frame giving information
  necessary to generate curves of observed FDR vs number of features called
  positive for each method and each stratification level.
}
\description{
Accessor and replacement functions for the \code{fdrnbrcurve} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrnbrcurve")
head(fdrnbrcurve(cobraperf))
}
\author{
Charlotte Soneson
}
