% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_performance.R
\name{calculate_performance}
\alias{calculate_performance}
\title{Calculate performance measures}
\usage{
calculate_performance(
  cobradata,
  binary_truth = NULL,
  cont_truth = NULL,
  aspects = c("fdrtpr", "fdrtprcurve", "fdrnbr", "fdrnbrcurve", "tpr", "fpr", "roc",
    "fpc", "overlap", "corr", "scatter", "deviation", "fsrnbr", "fsrnbrcurve"),
  thrs = c(0.01, 0.05, 0.1),
  svalthrs = c(0.01, 0.05, 0.1),
  splv = "none",
  maxsplit = 3,
  onlyshared = FALSE,
  thr_venn = 0.05,
  type_venn = "adjp",
  topn_venn = 100,
  rank_by_abs = TRUE,
  prefer_pval = TRUE
)
}
\arguments{
\item{cobradata}{A \code{COBRAData} object.}

\item{binary_truth}{A character string giving the name of the column of
truth(cobradata) that contains the binary truth (true assignment of
variables into two classes, represented by 0/1).}

\item{cont_truth}{A character string giving the name of the column of
truth(cobradata) that contains the continuous truth (a continuous value
that the observations can be compared to).}

\item{aspects}{A character vector giving the types of performance measures 
to calculate. Must be a subset of c("fdrtpr", "fdrtprcurve", "fdrnbr",
"fdrnbrcurve", "tpr", "fpr", "roc", "fpc", "overlap", "corr", "scatter",
"deviation", "fsrnbr", "fsrnbrcurve").}

\item{thrs}{A numeric vector of adjusted p-value thresholds for which to
calculate the performance measures. Affects "fdrtpr", "fdrnbr", "tpr" and
"fpr".}

\item{svalthrs}{A numeric vector of s-value thresholds for which to calculate
the FSR. Affects "fsrnbr".}

\item{splv}{A character string giving the name of the column of
truth(cobradata) that will be used to stratify the results. The default
value is "none", indicating no stratification.}

\item{maxsplit}{A numeric value giving the maximal number of categories to
keep in the stratification. The largest categories containing both positive
and negative features will be retained. By setting this argument to `Inf`
or `NA_integer_`, all categories (as well as the order of categories) will
be retained.}

\item{onlyshared}{A logical, indicating whether to only consider features for
which both the true assignment and a result (p-value, adjusted p-value or
score) is given. If FALSE, all features contained in the truth table are
used.}

\item{thr_venn}{A numeric value giving the adjusted p-value threshold to use
to create Venn diagrams (if \code{type_venn} is "adjp").}

\item{type_venn}{Either "adjp" or "rank", indicating whether Venn diagrams
should be constructed based on features with adjusted p-values below a
certain threshold, or based on the same number of top-ranked features by
different methods.}

\item{topn_venn}{A numeric value giving the number of top-ranked features to
compare between methods (if \code{type_venn} is "rank").}

\item{rank_by_abs}{Whether to take the absolute value of the score before
using it to rank the variables  for ROC, FPC, FDR/NBR and FDR/TPR curves.}

\item{prefer_pval}{Whether to preferentially rank variables by p-values or
adjusted p-values rather than score for ROC and FPC calculations. From
version 1.5.5, this is the default behaviour. To obtain the behaviour of
previous versions, set to \code{FALSE}.}
}
\value{
A \code{COBRAPerformance} object
}
\description{
Calculate performance measures from a given collection of p-values, adjusted
p-values and scores provided in a \code{COBRAData} object.
}
\details{
Depending on the collection of observations that are available for a given
method, the appropriate one will be chosen for each performance measure. For
\code{fpr}, \code{tpr}, \code{fdrtpr}, \code{fdrnbr} and \code{overlap}
aspects, results will only be calculated for methods where adjusted p-values
are included in the \code{COBRAData} object, since these calculations make
use of specific adjusted p-value cutoffs. For \code{fdrtprcurve} and
\code{fdrnbrcurve} aspects, the \code{score} observations will be
preferentially used, given that they are monotonically associated with the
adjusted p-values (if provided). If the \code{score} is not provided, the
nominal p-values will be used, given that they are monotonically associated
with the adjusted p-values (if provided). In other cases, the adjusted
p-values will be used also for these aspects. For \code{roc} and \code{fpc},
the \code{score} observations will be used if they are provided, otherwise
p-values and, as a last instance, adjusted p-values. Finally, for the
\code{fsrnbr}, \code{corr}, \code{scatter} and \code{deviation} aspects, the
\code{score} observations will be used if they are provided, otherwise no
results will be calculated.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = c("fdrtpr", "fdrtprcurve",
                                               "tpr", "roc"),
                                   thrs = c(0.01, 0.05, 0.1), splv = "none")
}
\author{
Charlotte Soneson
}
