% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icnv_output_to_gb.R
\name{icnv_output_to_gb}
\alias{icnv_output_to_gb}
\title{Convert icnv.output to input for Genome Browser.}
\usage{
icnv_output_to_gb(chr = numeric(), icnv.output)
}
\arguments{
\item{chr}{CNV chromosome. Type integer.}

\item{icnv.output}{output from output_list_function}
}
\value{
matrix for Genome browser
}
\description{
We could add the output to custom tracks on Genome Browser. Remeber to choose 
human assembly matches your input data.
We color coded the CNVs to make it as consistant as IGV. To show color, 
click 'User Track after submission', and edit config to 
'visibility=2 itemRgb="On"'. Color see Github page for more example.
}
\examples{
icnv.output <- output_list(icnv_res=icnv_res0,sampleid=sampname_qc, CN=0, min_size=10000)
gb_input <- icnv_output_to_gb(chr=22,icnv.output)
write.table(gb_input,file='icnv_res_gb_chr22.tab',quote=FALSE,col.names=FALSE,row.names=FALSE)
}
