% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iCNV_detection_function.R
\name{iCNV_detection}
\alias{iCNV_detection}
\title{CNV detection}
\usage{
iCNV_detection(ngs_plr = NULL, snp_lrr = NULL, ngs_baf = NULL,
  snp_baf = NULL, ngs_plr.pos = NULL, snp_lrr.pos = NULL,
  ngs_baf.pos = NULL, snp_baf.pos = NULL, maxIt = 50, visual = 0,
  projname = "iCNV.", CN = 0, mu = c(-3, 0, 2), cap = FALSE)
}
\arguments{
\item{ngs_plr}{A list of NGS intensity data. Each entry is an individual. If no NGS data, no need to specify.}

\item{snp_lrr}{A list of SNP array intensity data. Each entry is an individual. If no SNP array data, no need to specify.}

\item{ngs_baf}{A list of NGS BAF data. Each entry is an individual. If no NGS data, no need to specify.}

\item{snp_baf}{A list of SNP array BAF data. Each entry is an individual. If no SNP array data, no need to specify.}

\item{ngs_plr.pos}{A list of NGS intensity postion data. Each entry is an individual with dimension= (#of bins or exons, 2(start and end position)). If no NGS data, no need to specify.}

\item{snp_lrr.pos}{A list of SNP array intensity postion data. Each entry is an individual with length=#of SNPs. If no SNP array data, no need to specify.}

\item{ngs_baf.pos}{A list of NGS BAF postion data. Each entry is an individual with length=#of BAFs. If no NGS data, no need to specify.}

\item{snp_baf.pos}{A list of SNP array BAF postion data. Each entry is an individual with length=#of BAFs. If no SNP array data, no need to specify.}

\item{maxIt}{An integer number indicate the maximum number of EM iteration if not converged during parameter inference. Type integer. Default 50.}

\item{visual}{An indicator variable with value {0,1,2}. 0 indicates no visualization, 1 indicates basic visualization, 2 indicates complete visualization (Note visual 2 only work for single platform and integer CN inferenced). Type integer. Default 0}

\item{projname}{A string as the name of this project. Type character. Default 'iCNV.'}

\item{CN}{An indicator variable with value {0,1} for whether wants to infer exact copy number. 0 no exact CN, 1 exact CN. Type integer. Default 0.}

\item{mu}{A length tree vectur specify means of intensity in mixture normal distribution (Deletion, Diploid, Duplification). Default c(-3,0,2)}

\item{cap}{A boolean decides whether we cap insane intensity value due to double deletion or mutiple amplification. Type logical. Default False}
}
\value{
(1) CNV inference, contains CNV inference, Start and end position for each inference, Conditional probability for each inference, mu for mixture normal, sigma for mixture normal, probability of CNVs, Z score for each inference.

(2) exact copy number for each CNV inference, if CN=1.
}
\description{
Copy number variation detection tool for germline data. Able to combine 
intensity and BAF from SNP array and NGS data.
}
\examples{
# icnv call without genotype (just infer deletion, duplication)
projname <- 'icnv.demo.'
icnv_res0 <- iCNV_detection(ngs_plr,snp_lrr,
                         ngs_baf,snp_baf,
                         ngs_plr.pos,snp_lrr.pos,
                         ngs_baf.pos,snp_baf.pos,
                         projname=projname,CN=0,mu=c(-3,0,2),cap=TRUE,visual = 1)
# icnv call with genotype inference and complete plot
projname <- 'icnv.demo.geno.'
icnv_res1 <- iCNV_detection(ngs_plr,snp_lrr,
                         ngs_baf,snp_baf,
                         ngs_plr.pos,snp_lrr.pos,
                         ngs_baf.pos,snp_baf.pos,
                         projname=projname,CN=1,mu=c(-3,0,2),cap=TRUE,visual = 2)
}
\keyword{BAF,}
\keyword{CNV,}
\keyword{Intensity}
\keyword{Platform}
\keyword{integration,}
