% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/multisplit.R
\name{multisplit}
\alias{multisplit}
\title{Variable Selection on Random Sample Splits.}
\usage{
multisplit(x, y, covar = NULL, B = 50)
}
\arguments{
\item{x}{The SNP data matrix, of size \code{nobs x nvar}. Each row represents
a subject, each column a SNP.}

\item{y}{The response vector. It can be continuous or discrete.}

\item{covar}{NULL or the matrix of covariates one wishes to control for, of
size \code{nobs x ncovar}.}

\item{B}{The number of random splits. Default value is 50.}
}
\value{
A data frame with 2 components. A matrix of size \code{B x [nobs/2]}
containing the second subsample of each split, and a matrix  of size
\code{B x [nobs/6]} containing the selected variables in each split.
}
\description{
Performs repeated variable selection via the lasso on random sample splits.
}
\details{
The samples are divided into two random splits of approximately
equal size. The first subsample is used for variable selection, which is
implemented using \pkg{\link{glmnet}}. The first \code{[nobs/6]} variables
which enter the lasso path are selected. The procedure is repeated \code{B}
times.

If one or more covariates are specified, these will be added unpenalized to
the regression.
}
\examples{
library(MASS)
x <- mvrnorm(60,mu = rep(0,200), Sigma = diag(200))
beta <- rep(1,200)
beta[c(5,9,3)] <- 3
y <- x \%*\% beta + rnorm(60)
res.multisplit <- multisplit(x, y)
}
\references{
Meinshausen, N., Meier, L. and Buhlmann, P. (2009), P-values for
high-dimensional regression, Journal of the American Statistical Association
104, 1671-1681.
}

