% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_barplot.R
\name{draw_barplot}
\alias{draw_barplot}
\title{Barplot for Gene Expression Percentiles}
\usage{
draw_barplot(
  object,
  assay_name,
  x_spec,
  facet_var = NULL,
  fill_var = NULL,
  percentiles = c(1/3, 2/3)
)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input.}

\item{assay_name}{(\code{string})\cr selects assay from input.}

\item{x_spec}{(\code{GeneSpec})\cr gene specification for the x-axis.}

\item{facet_var}{(\code{string} or \code{NULL})\cr optional faceting variable, taken
from input sample variables.}

\item{fill_var}{(\code{string} or \code{NULL})\cr optional fill variable, taken
from input sample variables.}

\item{percentiles}{(\code{vector})\cr lower and upper percentiles to dichotomize
the gene counts into two or three categories.}
}
\value{
The \code{ggplot} barplot.
}
\description{
This produces a barplot of the dichotomized gene expression counts into two or three
categories based on custom defined percentiles.
}
\examples{
object <- hermes_data

g <- genes(object)

draw_barplot(
  object,
  assay_name = "counts",
  x_spec = gene_spec(g[1]),
  facet_var = "SEX",
  fill_var = "AGE18"
)

draw_barplot(
  object,
  assay_name = "counts",
  x_spec = gene_spec(g[1:3], colMedians, "Median"),
  facet_var = "SEX",
  fill_var = "AGE18"
)

draw_barplot(
  object,
  assay_name = "counts",
  x_spec = gene_spec(g[1:3], colMeans, "Mean"),
  facet_var = "SEX",
  fill_var = "AGE18",
  percentiles = c(0.1, 0.9)
)
}
