% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_cdisc.R
\name{col_data_with_genes}
\alias{col_data_with_genes}
\title{Sample Variables with Selected Gene Information}
\usage{
col_data_with_genes(object, assay_name, genes)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input experiment.}

\item{assay_name}{(\code{string})\cr which assay to use.}

\item{genes}{(\code{GeneSpec})\cr which genes or which gene signature should be extracted.}
}
\value{
The combined data set, where the additional attribute \code{gene_cols} contains
the names of the columns obtained by extracting the \code{genes} information.
}
\description{
This obtains the sample variables of a \code{HermesData} object together
with selected gene information.
}
\note{
The class of the returned data set will depend on the class of \code{colData}, so usually
will be \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DFrame}}.
}
\examples{
result <- col_data_with_genes(hermes_data, "counts", gene_spec("GeneID:1820"))
tail(names(result))
result$GeneID.1820
}
