\name{mutationSpectra}
\alias{mutationSpectrum}
\alias{bases}
\alias{variantCalls}

\title{Mutation spectrum analyses}

\description{ These functions help in analyses of mutation spectra}
\usage{
mutationSpectrum( variantCalls, tallyFile, study, context = 1 )
}

\arguments{
  \item{variantCalls}{
    A \code{data.frame} object that can be the output of a call to a
    \code{callVariantsPaired} or \code{callDeletionsPaired} function.
    The following columns are required:
    - \code{altAllele}
    - \code{refAllele}
    - \code{Sample}
    - \code{Start}
    - \code{End}
    - \code{Chrom}
  }
  \item{tallyFile}{
    filename of a tally file matching the variant calls
  }
  \item{study}{
    the study id used in the tally file
  }
  
  \item{context}{
    An integer specifying the size of the context that should be
    considered (i.e. the length of the prefix and suffix of the variant
    call)}
}
\details{
  This function takes a set of variant calls (SNVs/Deletions) and a tallyFile as well
  as a context size and tabulates the number of observed mutations
  stratified by type (refAllele->altAllele) and sequence context
  (i.e. the prefix and suffix of size \code{context} around the variant
  position in the genome)

  \code{bases} serves to map character representations to numeric
  encoding of bases

  \code{variantCalls} is an example dataset of variant calls created by
  running \code{callVariantsPaired} on the \code{example.tally.hfs5} file.
}
\value{
  A table listing the counts of mutations stratified by allele, sequence
  context and sample.
}
\author{
Paul Pyl
}

\examples{
  library(h5vc)
  tallyFile <- system.file( "extdata", "example.tally.hfs5", package = "h5vcData" )
  data( "example.variants", package = "h5vcData" )
  head( mutationSpectrum( variantCalls, tallyFile, "/ExampleStudy" ) )
}
