% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeWiggle.R
\name{writeWiggle}
\alias{writeWiggle}
\title{writeWiggle writes a wiggle track or BigWig file suitable for uploading
to the UCSC genome browser.}
\usage{
writeWiggle(
  reads,
  file,
  strand = "*",
  fileType = "wig",
  size = 50,
  normCounts = NULL,
  reverse = FALSE,
  seqinfo = NULL,
  track.type.line = FALSE,
  ...
)
}
\arguments{
\item{reads}{GenomicRanges object representing the position of reads
mapping in the genome.}

\item{file}{Specifies the filename for output.}

\item{strand}{Takes values of "+", "-", or "*".  Computes Writes a wiggle
on the speicified strand.  "*" denotes collapsing reads on both strands.
Default: "*".}

\item{fileType}{Takes values of "wig" or "BigWig". Default: "wig".}

\item{size}{Size of the moving window.}

\item{normCounts}{A normalization factor correcting for library size
or other effects.  For example, total mappible read counts might be a
reasonable value.  Default: 1 (i.e. no normalization).}

\item{reverse}{If set to TRUE, multiplies values by -1.
Used for reversing GRO-seq data on the negative (-) strand. Default: FALSE}

\item{seqinfo}{Seqinfo object for reads. Default: NULL.}

\item{track.type.line}{If set to TRUE, prints a header identifying the
file as a wiggle.  Necessary to upload a custom track to the UCSC
genome browser.  Default: TRUE}

\item{...}{Extra argument passed to mclapply.}
}
\description{
writeWiggle writes a wiggle track or BigWig file suitable for uploading
to the UCSC genome browser.
}
\examples{
S0mR1 <- as(readGAlignments(system.file("extdata", "S0mR1.bam",
package="groHMM")), "GRanges")
## Not run:
# writeWiggle(reads=S0mR1, file="S0mR1_Plus.wig", fileType="wig",
# strand="+", reverse=FALSE)
}
\author{
Minho Chae and Charles G. Danko
}
