% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEffNboot.R
\name{getEffNboot}
\alias{getEffNboot}
\alias{getEffNboot.equivSDhtest}
\alias{getEffNboot.equivSDhtestList}
\alias{getEffNboot.AllEquivSDhtest}
\title{Access to the number of effective bootstrap replicates in one or more equivalence test
results (only for their bootstrap version)}
\usage{
getEffNboot(x, ...)

\method{getEffNboot}{equivSDhtest}(x, ...)

\method{getEffNboot}{equivSDhtestList}(x, simplify = TRUE, ...)

\method{getEffNboot}{AllEquivSDhtest}(x, onto, GOLevel, listNames, simplify = TRUE, ...)
}
\arguments{
\item{x}{an object of class "equivSDhtest" or "equivSDhtestList" or "allEquivSDtest".}

\item{...}{Additional parameters.}

\item{simplify}{logical, if TRUE the result is simplified, e.g., returning a vector instead
of a matrix.}

\item{onto}{character, a vector with one or more of "BP", "CC" or "MF", ontologies to access.}

\item{GOLevel}{numeric or character, a vector with one or more GO levels to access.
See the details section and the examples.}

\item{listNames}{character(2), the names of a pair of gene lists.}
}
\value{
When \code{x} is an object of class "equivSDhtest" (i.e., the result of a single
equivalence test), the returned value is a single numeric value, the number of effective
bootstrap replicates, or \code{NA} if bootstrapping has not been performed.
For an object of class "equivSDhtestList" (i.e. all pairwise tests for a
set of gene lists), if \code{simplify = TRUE} (the default), the resulting value is a vector
with the number of effective bootstrap replicates in all those tests, or the symmetric matrix
of all these values if \code{simplify = TRUE}.
If \code{x} is an object of class "allEquivSDtest"
(i.e., the test iterated along GO ontologies and levels), the preceding result is returned in
the form of a list along the ontologies, levels and pairs of gene lists specified by the arguments
\code{onto, GOlevel} and \code{listNames} (or all present in \code{x} for missing arguments).
}
\description{
Given objects representing the result(s) of one or more equivalence tests
(classes "equivSDhtest", "equivSDhtestList" or "allEquivSDtest", i.e., the
result of functions 'equivTestSorensen' and 'allEquivTestSorensen'), this
function returns the number of effective bootstrap replicates. Obviously,
this only applies to calls of these functions with the parameter
boot = TRUE, otherwise it returns a NA value. See the details section for
further explanation.
}
\details{
In the bootstrap version of the equivalence test, resampling is performed generating new
bootstrap contingency tables from a multinomial distribution based on the "real", observed,
frequencies of mutual enrichment.
In some bootstrap resamples, the generated contingency table of mutual enrichment
may have very low frequencies of enrichment, which makes it unable for Sorensen-Dice
computations.
Then, the number of effective bootstrap resamples may be lower than those initially planned.
To get the number of initially planned bootstrap resamples use function \code{getNboot}.

Argument \code{GOLevel} can be of class "character" or "numeric". In the first case, the GO
levels must be specified like \code{"level 6"} or \code{c("level 4", "level 5", "level 6")}
In the second case ("numeric"), the GO levels must be specified like\code{6} or \code{seq.int(4,6)}.
}
\section{Methods (by class)}{
\itemize{
\item \code{getEffNboot(equivSDhtest)}: S3 method for class "equivSDhtest"

\item \code{getEffNboot(equivSDhtestList)}: S3 method for class "equivSDhtestList"

\item \code{getEffNboot(AllEquivSDhtest)}: S3 method for class "AllEquivSDhtest"

}}
\examples{
# Dataset 'allOncoGeneLists' contains the result of the equivalence test between gene lists
# 'sanger' and 'atlas', at level 4 of the BP ontology:
data(eqTest_atlas.sanger_BP4)
eqTest_atlas.sanger_BP4
class(eqTest_atlas.sanger_BP4)
# This may correspond to the result of code like:
# eqTest_atlas.sanger_BP4 <- equivTestSorensen(
#   allOncoGeneLists[["sanger"]], allOncoGeneLists[["atlas"]],
#   geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db",
#   onto = "BP", GOLevel = 4, listNames = c("sanger", "atlas"))
#
# (But results may vary according to GO updating)

# Not a bootstrap test, first upgrade to a bootstrap test:
boot.sanger_atlas.BP.4 <- upgrade(eqTest_atlas.sanger_BP4, boot = TRUE)

#getEffNboot(eqTest_atlas.sanger_BP4)
getEffNboot(boot.sanger_atlas.BP.4)
getNboot(boot.sanger_atlas.BP.4)

# All pairwise equivalence tests at level 4 of the BP ontology
data(eqTest_all_BP4)
?eqTest_all_BP4
class(eqTest_all_BP4)
# This may correspond to a call like:
# eqTest_all_BP4 <- equivTestSorensen(allOncoGeneLists,
#                           geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db",
#                           onto = "BP", GOLevel = 4)
boot.BP.4 <- upgrade(eqTest_all_BP4, boot = TRUE)
getEffNboot(eqTest_all_BP4)
getEffNboot(boot.BP.4)
getNboot(boot.BP.4)
getEffNboot(boot.BP.4, simplify = FALSE)

# Bootstrap equivalence test iterated over all GO ontologies and levels 3 to 10.
# data(allEqTests)
# ?allEqTests
# class(allEqTests)
# This may correspond to code like:
# (By default, the tests are iterated over all GO ontologies and for levels 3 to 10)
# allEqTests <- allEquivTestSorensen(allOncoGeneLists,
#                                             geneUniverse = humanEntrezIDs,
#                                             orgPackg = "org.Hs.eg.db",
#                                             boot = TRUE)
# boot.allEqTests <- upgrade(allEqTests, boot = TRUE)
# Number of effective bootstrap replicates for all tests:
# getEffNboot(boot.allEqTests)
# getEffNboot(boot.allEqTests, simplify = FALSE)

# Number of effective bootstrap replicates for specific GO ontologies, levels or pairs
# of gene lists:
# getEffNboot(boot.allEqTests, GOLevel = "level 6")
# getEffNboot(boot.allEqTests, GOLevel = 6)
# getEffNboot(boot.allEqTests, GOLevel = seq.int(4,6))
# getEffNboot(boot.allEqTests, GOLevel = "level 6", simplify = FALSE)
# getEffNboot(boot.allEqTests, GOLevel = "level 6", listNames = c("waldman", "sanger"))
# getEffNboot(boot.allEqTests, GOLevel = seq.int(4,6), onto = "BP")
# getEffNboot(boot.allEqTests, GOLevel = seq.int(4,6), onto = "BP", simplify = FALSE)
# getEffNboot(boot.allEqTests, GOLevel = "level 6", onto = "BP",
#             listNames = c("atlas", "sanger"))
# getEffNboot(boot.allEqTests$BP$`level 4`)

}
\seealso{
\code{\link{getNboot}}
}
