% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEquivTestSorensen.R
\name{allEquivTestSorensen}
\alias{allEquivTestSorensen}
\alias{allEquivTestSorensen.list}
\alias{allEquivTestSorensen.allTableList}
\title{Iterate \code{equivTestSorensen} along the specified GO ontologies and GO levels}
\usage{
allEquivTestSorensen(x, ...)

\method{allEquivTestSorensen}{list}(
  x,
  d0 = 1/(1 + 1.25),
  conf.level = 0.95,
  boot = FALSE,
  nboot = 10000,
  check.table = TRUE,
  ontos = c("BP", "CC", "MF"),
  GOLevels = seq.int(3, 10),
  trace = TRUE,
  ...
)

\method{allEquivTestSorensen}{allTableList}(
  x,
  d0 = 1/(1 + 1.25),
  conf.level = 0.95,
  boot = FALSE,
  nboot = 10000,
  check.table = TRUE,
  ontos,
  GOLevels,
  trace = TRUE,
  ...
)
}
\arguments{
\item{x}{either an object of class "list" or an object of class "allTableList". In the first
case, each of its elements must be a "character" vector of gene identifiers (e.g., ENTREZ).}

\item{...}{extra parameters for function \code{buildEnrichTable}.}

\item{d0}{equivalence threshold for the Sorensen-Dice dissimilarity, d.
The null hypothesis states that d >= d0, i.e., inequivalence between the compared
gene lists and the alternative that d < d0, i.e., equivalence or dissimilarity
irrelevance (up to a level d0).}

\item{conf.level}{confidence level of the one-sided confidence interval, a value between 0 and 1.}

\item{boot}{boolean. If TRUE, the confidence interval and the test p-value are computed by means
of a bootstrap approach instead of the asymptotic normal approach. Defaults to FALSE.}

\item{nboot}{numeric, number of initially planned bootstrap replicates. Ignored if
\code{boot == FALSE}. Defaults to 10000.}

\item{check.table}{Boolean. If TRUE (default), argument \code{x} is checked to adequately
represent a 2x2 contingency table (or an aggregate of them) or gene lists producing a correct
table. This checking is performed by means of function \code{nice2x2Table}.}

\item{ontos}{"character", GO ontologies to analyse. Defaults to \code{c("BP", "CC", "MF")}.}

\item{GOLevels}{"integer", GO levels to analyse inside each one of the GO ontologies.}

\item{trace}{Logical. If TRUE (default), the (usually very time consuming) process of function
\code{allEquivTestSorensen} is traced along the specified GO ontologies and levels.}
}
\value{
An object of class "AllEquivSDhtest". It is a list with as many components as GO ontologies have been analysed.
Each of these elements is itself a list with as many components as GO levels have been analized.
Finally, the elements of these lists are objects as generated by \code{equivTestSorensen.list},
i.e., objects of class "equivSDhtestList" containing pairwise comparisons between gene lists.
}
\description{
Iterate \code{equivTestSorensen} along the specified GO ontologies and GO levels
}
\section{Methods (by class)}{
\itemize{
\item \code{allEquivTestSorensen(list)}: S3 method for class "list"

\item \code{allEquivTestSorensen(allTableList)}: S3 method for class "allTableList"

}}
\examples{
# Gene lists to be explored for enrichment:
data(allOncoGeneLists)

# Obtaining ENTREZ identifiers for the gene universe of humans:
library(org.Hs.eg.db)
humanEntrezIDs <- keys(org.Hs.eg.db, keytype = "ENTREZID")

# This example is highly time-consuming. It scans two GO ontologies and three
# GO levels inside them to perform the equivalence test.
# allEquivTestSorensen(allOncoGeneLists,
#                      geneUniverse = humanEntrezIDs, orgPackg = "org.Hs.eg.db",
#                      ontos = c("MF", "BP"), GOLevels = seq.int(4,6))
# When the "ontos" and "GOLevels" arguments are not supplied, the function computes 
# by default every possible contingency table between the lists being compared for 
# the three ontologies (BP, CC, MF) and GO levels from 3 to 10. 
#
# Much faster:
# Object \code{allContTabs} of class "allTableList" contains all the pairwise contingency tables of
# joint enrichment for the gene lists in \code{allOncoGeneLists}, obtained along all three GO
# ontologies and along GO levels 3 to 10:
data(allContTabs)
tests <- allEquivTestSorensen(allContTabs, ontos = c("MF", "BP"), GOLevels = seq.int(4,6))
tests$BP$`level 5`
getPvalue(tests)

}
