% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allBuildEnrichTable.R
\name{allBuildEnrichTable}
\alias{allBuildEnrichTable}
\title{Iterate \code{buildEnrichTable} along the specified GO ontologies and GO levels}
\usage{
allBuildEnrichTable(
  x,
  check.table = TRUE,
  ontos = c("BP", "CC", "MF"),
  GOLevels = seq.int(3, 10),
  storeEnrichedIn = TRUE,
  trace = TRUE,
  ...
)
}
\arguments{
\item{x}{object of class "list". Each of its elements must be a "character" vector of gene
identifiers (e.g., ENTREZ). Then all pairwise contingency tables of joint enrichment are built between
these gene lists, iterating the process for all specified GO ontologies and GO levels.}

\item{check.table}{Boolean. If TRUE (default), all resulting tables are checked by means
of function \code{nice2x2Table}.}

\item{ontos}{"character", GO ontologies to analyse. Defaults to \code{c("BP", "CC", "MF")}.}

\item{GOLevels}{"integer", GO levels to analyse inside each of these GO ontologies.}

\item{storeEnrichedIn}{logical, for each ontology and level under study, the matrix of enriched
(GO terms) x (gene lists) TRUE/FALSE values, must be stored in the result?}

\item{trace}{Logical. If TRUE (default), the (usually very time consuming) process of function
\code{allbuildEnrichTable} is traced along the specified GO ontologies and levels.}

\item{...}{extra parameters for function \code{buildEnrichTable}.}
}
\value{
An object of class "allTableList". It is a list with as many components as GO ontologies have been
analysed.
Each of these elements is itself a list with as many components as GO levels have been analised.
Finally, the elements of these lists are objects as generated by \code{buildEnrichTable.list},
i.e., objects of class "tableList" containing all pairwise contingency tables of mutual enrichment
between the gene lists in argument \code{x}.
}
\description{
Iterate \code{buildEnrichTable} along the specified GO ontologies and GO levels
}
\examples{
# This example is highly time-consuming. It scans two GO ontologies and three
# GO levels inside them to obtain the contingency tables of joint enrichment.

# Obtaining ENTREZ identifiers for the gene universe of humans:
# library(org.Hs.eg.db)
# humanEntrezIDs <- keys(org.Hs.eg.db, keytype = "ENTREZID")

# Gene lists to be explored for enrichment:
# data(allOncoGeneLists)

# Computing Contingency Tables for all the possible pairwise comparisons for
# the ontologies MF, BP, and the GO levels from 4 to 6:
# someOntosAndLevels <- allBuildEnrichTable(allOncoGeneLists,
#                                           geneUniverse = humanEntrezIDs, 
#                                           orgPackg = "org.Hs.eg.db",
#                                           ontos = c("MF", "BP"), 
#                                           GOLevels = seq.int(4,6))
# someOntosAndLevels$BP$`level 4`
# attr(someOntosAndLevels$BP$`level 4`, "enriched")
#
# To avoid storage-consuming redundancies, the table of GO terms x gene lists 
# enrichment is not stored for the full set of gene list pairs at each 
# ontology and level
# someOntosAndLevels$BP$`level 4`$Vogelstein
# attr(someOntosAndLevels$BP$`level 4`$Vogelstein, "enriched")
# someOntosAndLevels$BP$`level 4`$Vogelstein$atlas
# attr(someOntosAndLevels$BP$`level 4`$Vogelstein$atlas, "enriched")
#
# When the "ontos" and/or "GOLevels" arguments are not supplied, the function 
# computes by default every possible contingency table between the lists 
# being compared for the three ontologies (BP, CC, MF) and/or GO levels from
# 3 to 10.

}
