#' Example of the output produced by the function \code{enrichedIn}. It contains exclusively GO terms enriched in at least one list of \code{allOncoGeneLists}, ontology BP, GO-Level 4. 
#' 
#' @description
#' A matrix with columns representing the gene lists from \code{\link{allOncoGeneLists}}, and rows with GO terms in the BP ontology at GO-Level 4.
#' 
#' This matrix comprises logit values, with \code{TRUE} indicating that the associated GO term is enriched in the respective list, and \code{FALSE} indicating that the GO term is not enriched.
#' 
#' This matrix represents the output of the \code{\link{enrichedIn}} function with the argument \code{onlyEnriched = TRUE} (default), displaying exclusively the GO terms enriched in at least one list (only rows with at least one \code{TRUE}).
#' 
#' @details
#' The attribute \code{nTerms} of this matrix represents the total number of terms evaluated in the BP ontology at GO-Level 4. The difference between \code{nTerms} and the rows of this matrix indicates the number of non-enriched GO terms across all columns (i.e., rows filled with FALSE).
#' 
#' Please, consider this object as an illustrative example only, which is valid exclusively for the \code{\link{allOncoGeneLists}} data contained in this package. Note that gene lists, GO terms and Bioconductor may change over time. The current version of these results was generated with Bioconductor version 3.20.
#' 
#' @format An object of class "matrix" "array" 
#' @usage data(enrichedInBP4)
"enrichedInBP4"