% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{insertionDiagram}
\alias{insertionDiagram}
\title{Display number of copies of an insertion}
\usage{
insertionDiagram(insertion_data, style = 1, either_side = "default",
  insertion_label = "default", sector_colours = nice_colours,
  sector_border_colours = nice_colours, start_degree = 180,
  custom_sector_width = NULL, coverage_rectangle = NULL,
  coverage_data = NULL, custom_ylim = NULL,
  space_between_sectors = 15, sector_labels = TRUE,
  sector_label_size = 1.3, sector_label_colour = "black",
  label_data = NULL, label_colour = "black", link_colour = "default",
  label_size = 1.1, xaxis = TRUE, xaxis_label_size = 0.9,
  xaxis_colour = "#747577", xaxis_spacing = 10,
  xaxis_spacing_unit = "deg", link_ends = "default",
  track_height = 0.15, internal = FALSE)
}
\arguments{
\item{insertion_data}{A \code{\link{GRanges}} or data frame describing the
insertion. See below for the detailed format.}

\item{style}{How the original sequence and insertions will be positioned
around the circle. Choose from options 1, 2, 3 or 4. Please see the examples
below or the vignette for what these options represent.}

\item{either_side}{How much extra of the genome should be shown around the
insertion site. Can be either a single number (e.g. \code{1000}, then 1000bp
will be shown either side of the insertion site), a vector of length 2
(e.g. \code{c(2000, 13000)} in which case from 2000 to 13000 will be shown)
or a GRanges (in which case all ranges in the GRanges object will be used
to determine the start/end points of the sector)}

\item{insertion_label}{The label(s) that will be applied to the insertions.
If \code{'default'} then the name of the insertion will be used to label
single copy insertions and a number will be used for multiple copy number
insertions. Otherwise, \code{insertion_label} should be a vector with one
element for each row of the insertion data, indicating the label that should
be used for that insertion.}

\item{sector_colours}{Either a single colour (which will be applied to all
sectors) or a vector with the same length as the number of sectors/regions.
This package includes 5 colour sets: \code{nice_colours},
\code{pastel_colours}, \code{bright_colours_transparent},
\code{bright_colours_opaque} and \code{rich_colours}. See
\code{\link{colourSets}} for more information about these.}

\item{sector_border_colours}{Same as \code{sector_colours}, only for the
border of each sector.}

\item{start_degree}{Where on the circle the first sector will start being
drawn from (90 = 12 o'clock).}

\item{custom_sector_width}{Normally, the size of each sector is proportional
to its relative length, but \code{custom_sector_width} can change this. It
is a vector of sector sizes (as proportions of the entire circle), given in
the same order in which sectors are plotted: firstly 'chr1', 'chr2' ...
through to 'chrX' and 'chrY' followed by any differently named sectors e.g.
'gene 1', plasmid' in alphabetical order.}

\item{coverage_rectangle}{A vector containing the name(s) of any sector(s)
that you would like to depict as 'coverage rectangles': filled in shapes
that are a plot of the coverage data over that sector. See the example below
or the vignette for an example of this.}

\item{coverage_data}{A GRanges (or data frame) containing the coverage data
to plot for those sectors in \code{coverage_rectangle}. To read this data in
from a BAM file, please see the \code{\link{getCoverage}} function.}

\item{custom_ylim}{A vector of length two containing the y (coverage) axis
limits. No need to set if not using coverage rectangles or if you're happy
with the default: c(0, maximum coverage).}

\item{space_between_sectors}{Space between each sector.}

\item{sector_labels}{If \code{TRUE}, labels ('chr1', 'chr2' etc.) will be
drawn for each sector (recommended).}

\item{sector_label_size}{Size of the sector labels.}

\item{sector_label_colour}{Colour of the sector labels.}

\item{label_data}{Data frame or \linkS4class{GRanges} containing the
labels. If a GRanges, \code{label} should be a metadata column containing
the character strings of the labels. \code{type} and \code{colour} can also
be used to store additional information about the type (e.g. 'gene' or
'promoter') and colour of the label. This information can be used to
\bold{colour code} the labels by supplying the colour column as the
\code{label_colour} parameter. Data frames should additionally include the
\code{chr}, \code{start}, \code{end} which dictate the position of the
label.}

\item{label_colour}{Colour of the labels, can be either a single value
(applied to all labels) or a vector with the same length as the number of
labels (for colour-coding).}

\item{link_colour}{The colour of the link: this should be a 6 digit hex
code, the transparency is automatically added.}

\item{label_size}{Size of the labels.}

\item{xaxis}{If \code{TRUE}, an x (genomic position) xaxis  will be plotted.}

\item{xaxis_label_size}{Size of the x axis labels.}

\item{xaxis_colour}{Colour of the x axis labels.}

\item{xaxis_spacing}{Space between the x axis labels, in degrees.
Alternatively, the string 'start_end' will place a label at the start and
end of each sector only.}

\item{xaxis_spacing_unit}{Either \code{"deg"} to draw ticks every certain
number of degrees around the circle or \code{"bp"} to draw ticks every
certain bp around the circle (be warned that when the scales for each sector
are very different, it's best to use \code{"deg"})}

\item{link_ends}{How far the link extends in either direction. \emph{This is
set automatically} but if you want to edit it, provide a vector of length 2
with each element being between 0 (centre of circle) and 1 (right at the
edge of the circle).}

\item{track_height}{The height (vertical distance around the circle) that
will be taken up by this track. Should be a number between 0 (none) and 1
(entire circle).}

\item{internal}{For internal use only.}
}
\value{
Generates an image displaying the copy number of the insertion(s)
provided
}
\description{
Generates a diagram which displays insertions, showing their
position, size and copy number. See \code{\link{featureDiagram}} for
a more general function which can display other features of interest.
}
\section{Insertion data format}{

The start, end and seqnames of insertion_data \linkS4class{GRanges} should
describe the insertion site. Additionally, there are five metadata columns:
\describe{
\item{name}{A character string which will be used to label insertion. It
is suggested to keep this label relatively short, if possible.}
\item{colour}{A character string of a colour to use. Supports hex colours
(\emph{e.g. #000000}) and named R colours (\emph{e.g. red}).}
\item{shape}{The shape that will be used to represent the feature: \itemize{
\item{\code{'rectangle'}} is a rectangle.
\item{\code{'forward_arrow'}} for a forwards facing arrow.
\item{\code{'reverse_arrow'}} for a backwards (reverse) facing arrow.} It is
suggested to use \code{'forward_arrow'}}
\item{length}{The length of the insertion}
\item{in_tandem}{The number of copies of the insert in tandem}}
The columns \strong{in_tandem, colour and shape are all optional}. If you
don't supply them, then default values will be added as follows: \describe{
\item{in_tandem}{1 (only one copy inserted)}
\item{colour}{a colour allocated from \code{\link{rich_colours}}}
\item{shape}{\code{'forward_arrow'}}}
}

\section{Warning}{

If you choose to use a data frame to supply the insertion_data, please be
careful to add the \code{stringsAsFactors=FALSE} argument. Otherwise, the
colours may not be correct.
}

\examples{
## one insertion with 4 tandem copies
## the data as a data.frame
exampleins <- data.frame(
chr='chr12', start=70905597, end=70917885, name='plasmid',
colour='#7270ea', length=12000, in_tandem=11, shape='forward_arrow',
stringsAsFactors=FALSE)

## or we can supply it as GRanges (same thing)
exampleins <- GRanges(
seqnames='chr12', ranges=IRanges(start=70905597, end=70917885),
name='plasmid', colour='#7270ea', length=12000, in_tandem=11,
shape='forward_arrow')

## plot it
insertionDiagram(exampleins, either_side=c(70855503, 71398284))

## that was the default 'style'. The other 3 styles are:
## style 2
insertionDiagram(exampleins, either_side=c(70855503, 71398284), style=2)

## style 3
insertionDiagram(exampleins, either_side=c(70855503, 71398284), style=3)

## style 4
insertionDiagram(exampleins, either_side=c(70855503, 71398284), style=4)

## 2 different insertions
## the data
example2ins <- data.frame(
chr=c('chr12', 'chr12'), start=c(70905597, 70705597),
end=c(70917885, 70717885), name=c('plasmid1', 'plasmid2'),
colour=c('#7270ea', '#ea7082'), length=c(12000, 10000),
in_tandem=c(4, 8), shape=c('reverse_arrow', 'forward_arrow'),
stringsAsFactors=FALSE)

## plot it
insertionDiagram(example2ins, link_colour='#ffe677', start_degree=45)
}
\seealso{
\code{\link{featureDiagram}} for a more flexible function
that takes a similar approach to representing features of interest.
}
