% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{intern.select}
\alias{intern.select}
\title{Internal function}
\usage{
intern.select(i, Y, Ystart, Yend, X, Xloc,
             window, offset, group,
             perm, phi, kind)
}
\arguments{
\item{i}{index}

\item{Y}{RNA-Seq data\strong{:}
numeric matrix with \code{q} rows (genes)
and \code{n} columns (samples);
or a SummarizedExperiment object}

\item{Ystart}{location (or start location)}

\item{Yend}{location (or end location)}

\item{X}{genomic profile\strong{:}
numeric matrix with \code{p} rows (covariates)
and \code{n} columns (samples)}

\item{Xloc}{location covariates\strong{:}
numeric vector of length \code{p}}

\item{window}{maximum distance\strong{:}
non-negative real number}

\item{offset}{numeric vector of length \code{n}}

\item{group}{confounding variable\strong{:}
factor of length \code{n}}

\item{perm}{number of iterations\strong{:}
positive integer}

\item{phi}{dispersion parameters\strong{:} vector of length \code{q}}

\item{kind}{computation \strong{:}
number between 0 and 1}
}
\value{
The function returns a dataframe,
with the p-value in the first column,
and the test statistic in the second column.
}
\description{
Communicates between \code{\link{cursus}} and \code{\link{omnibus}}
by selecting the covariates of interest.
}
\examples{
# simulate high-dimensional data
n <- 30
q <- 10
p <- 100
set.seed(1)
Y <- matrix(rnbinom(q*n,mu=10,
    size=1/0.25),nrow=q,ncol=n)
X <- matrix(rnorm(p*n),nrow=p,ncol=n)
Yloc <- seq(0,1,length.out=q)
Xloc <- seq(0,1,length.out=p)
window <- 1

# hypothesis testing
cursus(Y,Yloc,X,Xloc,window)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)
}
\seealso{
This is an \code{\link{internal}} function. The user functions
are \code{\link{cursus}}, \code{\link{omnibus}},
and \code{\link{proprius}}.
}
\keyword{internal}
