% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_functions.R
\name{cursus}
\alias{cursus}
\title{Genome-wide analysis}
\usage{
cursus(Y, Yloc, X, Xloc, window,
        Ychr = NULL, Xchr = NULL,
        offset = NULL, group = NULL,
        perm = 1000, nodes = 2,
        phi = NULL, kind = 0.01)
}
\arguments{
\item{Y}{\strong{RNA-Seq data}\strong{:}
numeric matrix with \code{q} rows (genes)
and \code{n} columns (samples);
or a SummarizedExperiment object}

\item{Yloc}{\strong{location RNA-Seq}\strong{:}
numeric vector of length \code{q}
(point location)\strong{;}
numeric matrix with \code{q} rows
and two columns (start and end locations)}

\item{X}{\strong{genomic profile}\strong{:}
numeric matrix with \code{p} rows (covariates)
and \code{n} columns (samples)}

\item{Xloc}{\strong{location covariates}\strong{:}
numeric vector of length \code{p}}

\item{window}{\strong{maximum distance}\strong{:}
non-negative real number}

\item{Ychr}{chromosome RNA-Seq\strong{:}
factor of length \code{q}}

\item{Xchr}{chromosome covariates\strong{:}
factor of length \code{p}}

\item{offset}{numeric vector of length \code{n}}

\item{group}{confounding variable\strong{:}
factor of length \code{n}}

\item{perm}{number of iterations\strong{:}
positive integer}

\item{nodes}{number of cluster nodes for parallel computation}

\item{phi}{dispersion parameters\strong{:} vector of length \code{q}}

\item{kind}{computation \strong{:}
number between 0 and 1}
}
\value{
The function returns a dataframe,
with the p-values in the first row
and the test statistics in the second row.
}
\description{
This function tests for associations between gene expression
or exon abundance (\code{Y})
and genetic or epigenetic alterations (\code{X}).
Using the locations of genes (\code{Yloc}),
and the locations of genetic
or epigenetic alterations (\code{Xloc}),
the expression of each gene is tested for associations with 
alterations on the same chromosome that are closer to the gene
than a given distance (\code{window}).
}
\details{
Note that \code{Yloc}, \code{Xloc} and \code{window} must
be given in the same unit, usually in base pairs.
If \code{Yloc} indicates interval \strong{locations},
and \code{window} is zero,
then only covariates between the start and end location
of the gene are of interest.
Typically \code{window} is larger than one million base pairs.

If \code{Y} and \code{X} include data from a single chromosome,
\code{Ychr} and \code{Xchr} are redundant.
If \code{Y} or \code{X} include data
from \strong{multiple chromosomes},
\code{Ychr} and \code{Xchr} should be specified
in order to prevent confusion between chromosomes. 

For the simultaneous analysis of
\strong{multiple genomic profiles}
\code{X} should be a list of numeric matrices with
\code{n} columns (samples),
\code{Xloc} a list of numeric vectors,
and \code{window} a list of non-negative real numbers.
If provided, \code{Xchr} should be alist of of numeric vectors.

The \code{offset} is meant to account for
different \strong{libary sizes}.
By default the \code{offset} is calculated based on \code{Y}.
Different library sizes can be ignored by 
setting the \code{offset} to \code{rep(1,n)}.

The user can provide the \strong{confounding} variable \code{group}.
Note that each level of \code{group} must appear at least twice
in order to allow stratified permutations.

Efficient alternatives to classical \strong{permutation} (\code{kind=1})
are the method of control variates (\code{kind=0})
and permutation in chunks (0 < \code{kind} < 1)
\link[=intern.crude]{details}.
}
\examples{
# simulate high-dimensional data
n <- 30; q <- 10; p <- 100
Y <- matrix(rnbinom(q*n,mu=10,
    size=1/0.25),nrow=q,ncol=n)
X <- matrix(rnorm(p*n),nrow=p,ncol=n)
Yloc <- seq(0,1,length.out=q)
Xloc <- seq(0,1,length.out=p)
window <- 1

# hypothesis testing
cursus(Y,Yloc,X,Xloc,window)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)

RX Menezes, M Boetzer, M Sieswerda, GJB van Ommen, and JM Boer (2009).
"Integrated analysis of DNA copy number
and gene expression microarray data using gene sets",
\emph{BMC Bioinformatics}. 10:203.
\href{http://dx.doi.org/10.1186/1471-2105-10-203}{html}
\href{http://www.biomedcentral.com/content/pdf/1471-2105-10-203.pdf}{pdf}
(open access)
}
\seealso{
The function \code{\link{omnibus}} tests for associations
between an overdispersed response variable
and a high-dimensional covariate set.
The function \code{\link{proprius}} calculates the contributions
of individual samples or covariates to the test statistic.
All other function of the R package
\code{\link{globalSeq}} are \code{\link{internal}}.
}
\keyword{methods}
