% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_apis.R
\name{protein2EnsemblGeneNames}
\alias{protein2EnsemblGeneNames}
\title{Retrieve ensembl gene ids from proteins}
\usage{
protein2EnsemblGeneNames(
  ensemblProteins,
  useCache = TRUE,
  verbose = FALSE,
  ensembl.proteins = deprecated(),
  use.cache = deprecated()
)
}
\arguments{
\item{ensemblProteins}{character vector with gene names in
ensembl_peptide_id format}

\item{useCache}{Boolean indicating if biomaRt cache should be used}

\item{verbose}{When using biomaRt in webservice mode and setting verbose to
TRUE, the XML query to the webservice will be printed.}

\item{ensembl.proteins}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{use.cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
a dataframe with external gene names, ensembl_peptide_id
}
\description{
Retrieve ensembl gene ids from proteins
}
\examples{
protein2EnsemblGeneNames(c(
    "ENSP00000235382",
    "ENSP00000233944",
    "ENSP00000216911"
))
}
