% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot}
\alias{autoplot}
\alias{autoplot.hclust}
\alias{autoplot.linkage}
\alias{autoplot.dendrogram}
\alias{autoplot.agnes}
\alias{autoplot.diana}
\alias{autoplot.twins}
\alias{autoplot.bclust}
\alias{autoplot.hdbscan}
\alias{autoplot.hkmeans}
\alias{autoplot.dendro}
\alias{autoplot.pvclust}
\alias{autoplot.ClusterExperiment}
\alias{autoplot.genoMatriXeR}
\alias{autoplot.multiLocalZScore}
\title{autoplot}
\usage{
autoplot(object, ...)

\method{autoplot}{hclust}(object, layout = "dendrogram", ladderize = FALSE, hang = 0.1, ...)

\method{autoplot}{linkage}(object, layout = "dendrogram", ladderize = FALSE, hang = 0.1, ...)

\method{autoplot}{dendrogram}(object, layout = "dendrogram", ladderize = FALSE, hang = 0.1, ...)

\method{autoplot}{agnes}(object, layout = "dendrogram", ladderize = FALSE, hang = 0.1, ...)

\method{autoplot}{diana}(object, layout = "dendrogram", ladderize = FALSE, hang = 0.1, ...)

\method{autoplot}{twins}(object, layout = "dendrogram", ladderize = FALSE, hang = 0.1, ...)

\method{autoplot}{bclust}(object, ...)

\method{autoplot}{hdbscan}(object, ...)

\method{autoplot}{hkmeans}(object, ...)

\method{autoplot}{dendro}(object, ...)

\method{autoplot}{pvclust}(
  object,
  layout = "dendrogram",
  ladderize = FALSE,
  label_edge = FALSE,
  pvrect = FALSE,
  alpha = 0.95,
  hang = 0.1,
  ...
)

\method{autoplot}{ClusterExperiment}(object, layout = "rectangular", ...)

\method{autoplot}{genoMatriXeR}(object, hctype = "rows", ...)

\method{autoplot}{multiLocalZScore}(object, ...)
}
\arguments{
\item{object}{input object}

\item{...}{additional paramters that passed to ggtree}

\item{layout}{layout for plotting the tree}

\item{ladderize}{logical whether ladderize the tree (default FALSE)}

\item{hang}{numeric The fraction of the tree plot height by which labels
should hang below the rest of the plot. A negative value will cause the
labels to hang down from 0.}

\item{label_edge}{logical whether display the label of edge (only for
pvclust object), default is FALSE.}

\item{pvrect}{logical whether display the clusters with relatively high/low
p-values, default is FALSE. (only for pvclust object)}

\item{alpha}{numeric the threshold value for p-values, default is 0.95 (only
for pvclust object).}
}
\value{
ggtree object
}
\description{
autoplot
}
\examples{
d <- dist(USArrests)
hc <- hclust(d, "ave")
autoplot(hc) + geom_tiplab()
}
