% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotObsQC.R
\name{plotObsQC}
\alias{plotObsQC}
\alias{plotQC}
\alias{plotSpotQC}
\title{plotObsQC}
\usage{
plotObsQC(
  spe,
  plot_type = c("histogram", "scatter", "spot", "violin"),
  x_coord = NULL,
  y_coord = NULL,
  x_metric = NULL,
  y_metric = NULL,
  x_threshold = NULL,
  y_threshold = NULL,
  trend = TRUE,
  marginal = TRUE,
  annotate = NULL,
  in_tissue = NULL,
  legend_point_size = 3,
  n_bins = 100,
  point_size = 0.3,
  y_reverse = TRUE
)

plotQC(...)

plotSpotQC(...)
}
\arguments{
\item{spe}{Input data, assumed to be a \code{SpatialExperiment} or
\code{SingleCellExperiment} object.}

\item{plot_type}{Type of QC plot. Options are "histogram", "scatter", "spot",
and "violin". See Details for additional details.}

\item{x_coord}{Name of column in \code{spatialCoords} (for a
\code{SpatialExperiment} input object) or \code{colData} (for a
\code{SingleCellExperiment} input object) containing x coordinates. Default
= NULL (for a \code{SpatialExperiment}, the first column of
\code{spatialCoords} will be selected in this case). Used for spot plots.}

\item{y_coord}{Name of column in \code{spatialCoords} (for a
\code{SpatialExperiment} input object) or \code{colData} (for a
\code{SingleCellExperiment} input object) containing y coordinates. Default
= NULL (for a \code{SpatialExperiment}, the second column of
\code{spatialCoords} will be selected in this case). Used for spot plots.}

\item{x_metric}{Name of column in \code{colData} containing QC metric to plot
on x-axis. Required for histograms, scatter plots, and violin plots.}

\item{y_metric}{Name of column in \code{colData} containing QC metric to plot
on y-axis. Required for histograms, scatter plots, and violin plots.}

\item{x_threshold}{QC filtering threshold on x-axis metric to highlight with
vertical line. Default = NULL. Optional argument used for scatter plots.}

\item{y_threshold}{QC filtering threshold on y-axis metric to highlight with
horizontal line. Default = NULL. Optional argument used for scatter plots.}

\item{trend}{Whether to show smoothed trend line (loess). Default = TRUE.
Optional argument used for scatter plots.}

\item{marginal}{Whether to show marginal histograms. Default = TRUE. Optional
argument used for scatter plots.}

\item{annotate}{Name of column in \code{colData} identifying selected spots
that do not meet QC filtering thresholds, which will be highlighted on a
histogram, spot plot, or violin plot. Default = NULL. Optional argument
used for histograms, spot plots, and violin plots.}

\item{in_tissue}{Name of column in \code{colData} identifying spots over
tissue (e.g. "in_tissue" for 10x Genomics Visium datasets). If this
argument is provided, only spots over tissue will be shown. Default = NULL.
Optional argument used for spot plots.}

\item{legend_point_size}{Legend point size. Default = 3. Optional argument
used for spot plots.}

\item{n_bins}{Number of bins for histograms. Default = 100. Optional argument
used for histograms.}

\item{point_size}{Point size. Default = 0.3. Optional argument for scatter
plots, spot plots, and violin plots. Suggested values: 0.5 for scatter
plots, 0.3 for spot plots, 0.1 for violin plots.}

\item{y_reverse}{Whether to reverse y coordinates. This is usually required
for 10x Genomics Visium datasets when using the default coordinate values.
Default = TRUE. Set to FALSE if not needed, e.g. for other platforms.
Optional argument used for spot plots.}

\item{...}{Not used.}
}
\value{
Returns a ggplot object, which may be further modified using ggplot
  functions.
}
\description{
Plotting functions for spatial transcriptomics data.
}
\details{
Function to create observation-level quality control (QC) plots for spatial
transcriptomics data.

The following types of observation-level (i.e. spot-level or cell-level) QC
plots are available:

\itemize{
\item Histogram (\code{plot_type = "histogram"}) for a single QC metric, e.g.
number of UMI counts per spot. For number of counts per spot, the histogram
can optionally highlight selected spots, e.g. spots with low library size.
\item Scatter plot (\code{plot_type = "scatter"}) comparing two QC metrics,
e.g. number of detected features vs. number of cells per spot, with optional
horizontal and vertical lines highlighting QC filtering thresholds.
\item Spot plot (\code{plot_type = "spot"}) showing spots in spatial x-y
coordinates, e.g. highlighting selected spots that do not meet filtering
thresholds.
\item Violin plot (\code{plot_type = "violin"}) for a single QC metric, e.g.
number of UMI counts per spot. For number of counts per spot, the violin plot
can optionally highlight selected spots, e.g. spots with low library size.
}

For feature-level (i.e. gene-level) QC plots, see
\code{\link{plotFeatureQC}}.
}
\examples{
library(STexampleData)
spe <- Visium_humanDLPFC()

colData(spe)$sum <- colSums(counts(spe))
colData(spe)$low_libsize <- colData(spe)$sum < 400

plotObsQC(spe, plot_type = "histogram", x_metric = "sum", annotate = "low_libsize")
plotObsQC(spe, plot_type = "scatter", x_metric = "sum", y_metric = "cell_count")
plotObsQC(spe, plot_type = "spot", annotate = "low_libsize", in_tissue = "in_tissue")
plotObsQC(spe, plot_type = "violin", x_metric = "sum", annotate = "low_libsize")

}
\author{
Lukas M. Weber and Yixing E. Dong
}
