#' A sample data used in ggmsa
#'
#' A dataset containing the alignment sequences of 
#' the phenylalanine hydroxylase protein (PH4H) 
#' within nine species
#'
#'
#' @docType data
#' @keywords datasets
#' @name sample.fasta
#' @format A MSA fasta with 9 sequences and 456 positions.
NULL



#' GVariation
#'
#' A folder containing 4 MAS files as a sample
#' data set to identify the sequence recombination event.
#'
#' \itemize{
#'   \item A.Mont.fas MSA with sequences of 'Mont' and 'CF_YL21'
#'   \item B.Oz.fas MSA with sequences of 'Oz' and 'CF_YL21'
#'   \item C.Wilga5.fas MSA with sequences of 'Wilga5' and 'CF_YL21'
#'   \item sample_alignment.fa MSA with sequences of 'Mont', 'CF_YL21', 
#'   'Oz', and 'Wilga5'
#' }
#' @docType data
#' @keywords datasets
#' @name GVariation
#' @format a folder 
#' @source \url{https://link.springer.com/article/10.1007/s11540-015-9307-3}
NULL



#' Rfam
#'
#' A folder containing seed alignment sequences and 
#' corresponding consensus RNA secondary structure. 
#'
#' \itemize{
#'   \item RF00458.fasta seed alignment sequences of Cripavirus internal 
#'   ribosome entry site (IRES)
#'   \item RF03120.fasta seed alignment sequences of Sarbecovirus 5'UTR
#'   \item RF03120_SS.txt consensus RNA secondary structure of 
#'   Sarbecovirus 5'UTR
#'  
#' }
#' @docType data
#' @keywords datasets
#' @name Rfam
#' @format a folder 
#' @source \url{https://rfam.xfam.org/}
NULL



#' Gram-negative_AKL
#'
#' Amino acids in the adenylate kinase lid (AKL) domain
#' from Gram-negative bacteria. 
#'
#' @docType data
#' @keywords datasets
#' @name Gram-negative_AKL.fasta
#' @format A MSA fasta with 100 sequences and 36 positions.
#' @source \url{http://biovis.net/year/2013/info/redesign-contest}
NULL



#' Gram-positive_AKL
#'
#' Amino acids in the adenylate kinase lid (AKL) domain
#' from Gram-positive bacteria. 
#'
#' @docType data
#' @keywords datasets
#' @name Gram-positive_AKL.fasta
#' @format A MSA fasta with 100 sequences and 36 positions.
#' @source \url{http://biovis.net/year/2013/info/redesign-contest}
NULL



#' A sample DNA alignment sequences
#'
#' DNA alignment sequences with 24 sequences and 56 positions.
#'
#'
#' @docType data
#' @keywords datasets
#' @name LeaderRepeat_All.fa
#' @format A MSA fasta 
NULL



#' microRNA data used in ggmsa
#'
#'Fasta format sequences of mature miRNA sequences 
#'from miRBase
#'
#'
#' @docType data
#' @keywords datasets
#' @name seedSample.fa
#' @format A MSA fasta with 6 sequences and 22 positions.
#' @source \url{https://www.mirbase.org/ftp.shtml}
NULL



#' sequence-link-tree
#'
#' Alignment sequences used to demonstrate circular MSA layout
#'
#' @docType data
#' @keywords datasets
#' @name sequence-link-tree.fasta
#' @format A MSA fasta with 28 sequences and 480 positions.
NULL



#' TP53 MSA
#'
#' Alignment sequences of used to show graphical combination
#'
#' @docType data
#' @keywords datasets
#' @name tp53.fa
#' @format A MSA fasta with 5 sequences and 404 positions.
NULL



#' genome locus
#'
#' The local genome map shows the 30000 sites around the TP53 gene.
#'
#' @docType data
#' @keywords datasets
#' @name TP53_genes.xlsx
#' @format xlsx
NULL

