% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinpoints.R
\name{thinPoints}
\alias{thinPoints}
\title{Thin Data Points}
\usage{
thinPoints(dat, value, n = 1000, nbins = 200, groupBy = NULL)
}
\arguments{
\item{dat}{a data frame}

\item{value}{column name of \code{dat} to be used for partitioning (see details)}

\item{n}{number of points to sample for each partition}

\item{nbins}{number of partitions}

\item{groupBy}{column name of \code{dat} to group by before partitioning (e.g. chromosome)}
}
\value{
a \code{data.frame}
}
\description{
Reduce the number of cluttered data points.
}
\details{
The result of Genome Wide Association Study can be very large, with the majority
of points being being clustered below significance threshold. This unnecessarily increases the time
to plot while making almost no difference. This function reduces the number of points by partitioning the points
by a numeric column \code{value} into \code{nbins} and sampling \code{n} points.
}
\examples{
dat <- data.frame(
   A1 = c(1:20, 20, 20),
   A2 = c(rep(1, 12), rep(1,5), rep(20, 3), 20, 20) ,
   B = rep(c("a", "b", "c", "d"), times = c(5, 7, 8, 2))
)
# partition "A1" into 2 bins and then sample 6 data points
thinPoints(dat, value = "A1", n = 6, nbins = 2)
# partition "A2" into 2 bins and then sample 6 data points
thinPoints(dat, value = "A2", n = 6, nbins = 2)
# group by "B", partition "A2" into 2 bins and then sample 3 data points
thinPoints(dat, value = "A2", n = 3, nbins = 2, groupBy = "B")

}
