% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan.R
\name{manhattan_plot}
\alias{manhattan_plot}
\alias{manhattan_plot.default}
\alias{manhattan_plot.data.frame}
\alias{manhattan_plot.MPdata}
\alias{manhattan_plot,GRanges-method}
\title{Manhattan Plotting}
\usage{
manhattan_plot(x, ...)

manhattan_plot.default(x, ...)

\method{manhattan_plot}{data.frame}(
  x,
  chromosome = NULL,
  outfn = NULL,
  signif = c(5e-08, 1e-05),
  pval.colname = "pval",
  chr.colname = "chr",
  pos.colname = "pos",
  label.colname = NULL,
  highlight.colname = NULL,
  chr.order = NULL,
  signif.col = NULL,
  chr.col = NULL,
  highlight.col = NULL,
  rescale = TRUE,
  rescale.ratio.threshold = 5,
  signif.rel.pos = 0.2,
  chr.gap.scaling = 1,
  color.by.highlight = FALSE,
  preserve.position = FALSE,
  thin = NULL,
  thin.n = 1000,
  thin.bins = 200,
  pval.log.transform = TRUE,
  plot.title = ggplot2::waiver(),
  plot.subtitle = ggplot2::waiver(),
  plot.width = 10,
  plot.height = 5,
  plot.scale = 1,
  point.size = 0.75,
  label.font.size = 2,
  max.overlaps = 20,
  x.label = "Chromosome",
  y.label = expression(-log[10](p)),
  ...
)

\method{manhattan_plot}{MPdata}(
  x,
  chromosome = NULL,
  outfn = NULL,
  signif = NULL,
  signif.col = NULL,
  rescale = TRUE,
  rescale.ratio.threshold = 5,
  signif.rel.pos = 0.2,
  chr.gap.scaling = NULL,
  color.by.highlight = FALSE,
  label.colname = NULL,
  x.label = "Chromosome",
  y.label = expression(-log[10](p)),
  point.size = 0.75,
  label.font.size = 2,
  max.overlaps = 20,
  plot.title = ggplot2::waiver(),
  plot.subtitle = ggplot2::waiver(),
  plot.width = 10,
  plot.height = 5,
  plot.scale = 1,
  ...
)

\S4method{manhattan_plot}{GRanges}(
  x,
  chromosome = NULL,
  outfn = NULL,
  signif = c(5e-08, 1e-05),
  pval.colname = "pval",
  label.colname = NULL,
  highlight.colname = NULL,
  chr.order = NULL,
  signif.col = NULL,
  chr.col = NULL,
  highlight.col = NULL,
  rescale = TRUE,
  rescale.ratio.threshold = 5,
  signif.rel.pos = 0.2,
  chr.gap.scaling = 1,
  color.by.highlight = FALSE,
  preserve.position = FALSE,
  thin = NULL,
  thin.n = 1000,
  thin.bins = 200,
  pval.log.transform = TRUE,
  plot.title = ggplot2::waiver(),
  plot.subtitle = ggplot2::waiver(),
  plot.width = 10,
  plot.height = 5,
  plot.scale = 1,
  point.size = 0.75,
  label.font.size = 2,
  max.overlaps = 20,
  x.label = "Chromosome",
  y.label = expression(-log[10](p)),
  ...
)
}
\arguments{
\item{x}{a \code{data.frame}, an extension of \code{data.frame} object (e.g.
\code{tibble}), or an \code{MPdata} object.}

\item{...}{additional arguments to be passed onto \code{geom_label_repel}}

\item{chromosome}{a character. This is supplied if a manhattan plot of a single chromosome is
desired. If \code{NULL}, then all the chromosomes in the data will be plotted.}

\item{outfn}{a character. File name to save the Manhattan Plot. If \code{outfn}
is supplied (i.e. \code{!is.null(outfn)}), then the plot is not drawn in
the graphics window.}

\item{signif}{a numeric vector. Significant p-value thresholds to be drawn for manhattan plot.
At least one value should be provided. Default value is c(5e-08, 1e-5).
If \code{signif} is not \code{NULL} and \code{x} is an \code{MPdata} object,
\code{signif} argument overrides the value inside \code{MPdata}.}

\item{pval.colname}{a character. Column name of \code{x} containing p.value.}

\item{chr.colname}{a character. Column name of \code{x} containing chromosome.}

\item{pos.colname}{a character. Column name of \code{x} containing position.}

\item{label.colname}{a character. Name of the column in \code{MPdata$data}
to be used for labeling.}

\item{highlight.colname}{a character. If you desire to color certain points
(e.g. significant variants) rather than color by chromosome, you can specify the
category in this column, and provide the color mapping in \code{highlight.col}.
Ignored if \code{NULL}.}

\item{chr.order}{a character vector. Order of chromosomes presented in manhattan plot.}

\item{signif.col}{a character vector of equal length as \code{signif}.
It contains colors for the lines drawn at \code{signif}.
If \code{NULL}, the smallest value is colored black while others are grey. If \code{x} is an \code{MPdata} object,
behaves similarly to \code{signif}.}

\item{chr.col}{a character vector of equal length as chr.order. It contains colors
for the chromosomes. Name of the vector should match \code{chr.order}. If \code{NULL}, default
colors are applied using \code{RColorBrewer}.}

\item{highlight.col}{a character vector. It contains color mapping for the values from
\code{highlight.colname}.}

\item{rescale}{a logical. If \code{TRUE}, the plot will rescale itself depending
on the data. More on this in details.}

\item{rescale.ratio.threshold}{a numeric. Threshold of that triggers the rescale.}

\item{signif.rel.pos}{a numeric between 0.1 and 0.9. If the plot is rescaled,
where should the significance threshold be positioned?}

\item{chr.gap.scaling}{a numeric. scaling factor for gap between chromosome if you desire to change it
if x is an \code{MPdata} object, then the gap will scale relative to the gap in the object.}

\item{color.by.highlight}{a logical. Should the points be colored based on a highlight column?}

\item{preserve.position}{a logical. If \code{TRUE}, the width of each chromosome reflect the
number of variants and the position of each variant is correctly scaled? If \code{FALSE}, the
width of each chromosome is equal and the variants are equally spaced.}

\item{thin}{a logical. If \code{TRUE}, \code{thinPoints} will be applied. Defaults to \code{TRUE} if
\code{chromosome} is \code{NULL}. Defaults to \code{FALSE} if \code{chromosome} is supplied.}

\item{thin.n}{an integer. Number of max points per horizontal partitions of the plot.
Defaults to 1000.}

\item{thin.bins}{an integer. Number of bins to partition the data. Defaults to 200.}

\item{pval.log.transform}{a logical. If \code{TRUE}, the p-value will be transformed to -log10(p-value).}

\item{plot.title}{a character. Plot title}

\item{plot.subtitle}{a character. Plot subtitle}

\item{plot.width}{a numeric. Plot width in inches. Corresponds to \code{width} argument in \code{ggsave} function.}

\item{plot.height}{a numeric. Plot height in inches. Corresponds to \code{height} argument in \code{ggsave} function.}

\item{plot.scale}{a numeric. Plot scale. Corresponds to \code{scale} argument in \code{ggsave} function.}

\item{point.size}{a numeric. Size of the points.}

\item{label.font.size}{a numeric. Size of the labels.}

\item{max.overlaps}{an integer. Exclude text labels that overlaps too many things.}

\item{x.label}{a character. x-axis label}

\item{y.label}{a character. y-axis label}
}
\value{
\code{gg} object if \code{is.null(outfn)}, \code{NULL} if \code{!is.null(outf)}
}
\description{
A generic function for manhattan plot.
}
\details{
This generic function accepts a result of a GWAS in the form of \code{data.frame}
or a \code{MPdata} object produced by \code{manhattan_data_preprocess}. The
function will throw an error if another type of object is passed.

Having \code{rescale = TRUE} is useful when there are points with very
high -log10(p.value). In this case, the function attempts to split
the plot into two different scales, with the split happening near the strictest
significance threshold. More precisely, the plot is rescaled when
\deqn{-log10(pvalue) / (strictest significance threshold) \ge rescale.ratio.threshold}

If you wish to add annotation to the points, provide the name of the column to
\code{label.colname}. The labels are added with \code{\link{ggrepel}}.

Be careful though: if the annotation column contains
a large number of variants, then the plotting could take a long time, and the
labels will clutter up the plot. For those points with no annotation, you have the
choice to set them as \code{NA} or \code{""}.
}
\examples{

gwasdat <- data.frame(
  "chromosome" = rep(1:5, each = 30),
  "position" = c(replicate(5, sample(1:300, 30))),
  "pvalue" = rbeta(150, 1, 1)^5
)

manhattan_plot(
  gwasdat, pval.colname = "pvalue", chr.colname = "chromosome", pos.colname = "position",
  chr.order = as.character(1:5)
)

mpdata <- manhattan_data_preprocess(
  gwasdat, pval.colname = "pvalue", chr.colname = "chromosome", pos.colname = "position",
  chr.order = as.character(1:5)
)

manhattan_plot(mpdata)

}
