% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_inverse_trans.R
\name{axis_x_inverse_trans}
\alias{axis_x_inverse_trans}
\alias{axis_y_inverse_trans}
\title{Display ggcyto axis labels using their raw values (as stored in the data structure)}
\usage{
axis_x_inverse_trans(...)

axis_y_inverse_trans(...)
}
\arguments{
\item{...}{common continuous scale parameters passed to 'continuous_scale' (not used currently)}
}
\value{
a raw_scale object that inherits scale class.
}
\description{
It is essentially a dummy continous scale and will be instantiated
by '+.ggcyto_GatingSet' with 'breaks` and 'lables' customized.
}
\examples{
 dataDir <- system.file("extdata",package="flowWorkspaceData")
 gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
 p <- ggcyto(gs, aes(x = CD4, y = CD8), subset = "CD3+") + geom_hex(bins = 64)
 p <- p + geom_gate("CD4") + geom_stats() #plot CD4 gate and it is stats
 p
 p + axis_x_inverse_trans() #inverse transform the x axis into raw scale
}
