% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dclustering.R
\docType{data}
\name{geva.dcluster}
\alias{geva.dcluster}
\alias{options.dcluster.method}
\title{GEVA Density Clustering}

\usage{
geva.dcluster(
  sv,
  resolution = 0.3,
  dcluster.method = options.dcluster.method,
  cl.score.method = options.cl.score.method,
  minpts = 2,
  ...,
  eps = NA_real_,
  include.raw.results = FALSE
)

options.dcluster.method
# c("dbscan", "optics")
}
\arguments{
\item{sv}{a \code{numeric} \code{\linkS4class{SVTable}} object (usually \code{\linkS4class{GEVASummary}})}

\item{resolution}{\code{numeric} (\code{0} to \code{1}), used as a "zoom" parameter for cluster detection. A zero value returns the minimum number of clusters that can detected, while \code{1} returns the maximum amount of detectable clusters. Ignored if \code{eps} is specified}

\item{dcluster.method}{\code{character}, density-based method for cluster separation}

\item{cl.score.method}{\code{character}, method used to calculate the cluster scores for each point. If \code{"auto"}, the \code{"density"} method is selected}

\item{minpts}{\code{integer}, minimum number of points required to form a cluster}

\item{...}{additional arguments. Accepts \code{verbose} (\code{logical}, default is \code{TRUE}) to enable or disable printing the current progress}

\item{eps}{\code{numeric}, maximum neighborhood distance between points to be clustered}

\item{include.raw.results}{\code{logical}, whether to attach intermediate results to the returned object}
}
\value{
A \code{\linkS4class{GEVACluster}} object
}
\description{
Performs a density cluster analysis from summarized data.
}
\details{
This function performs a density cluster analysis with the aid of implemented methods from the \code{\link[dbscan:dbscan]{dbscan::dbscan}} package. The available methods for the \code{dcluster.method} arguments are \code{"dbscan"} and \code{"options"}, which internally call \code{\link[dbscan:dbscan]{dbscan::dbscan()}} and \code{\link[dbscan:optics]{dbscan::optics()}}, respectively.

The \code{resolution} value is an accessible way to define the cluster separation threshold used in density clustering. The \emph{DBSCAN} algorithm uses an \emph{epsilon} value that represents the minimum distance of separation, and \code{resolution} translates a value between \code{0} and \code{1} to a propotional value within the acceptable range of \emph{epsilon} values. This allows defining the rate of clusters from \code{0} to \code{1}, which results in the least number of possible clusters for \code{0} and the highest number for \code{1}. Nevertheless, if \emph{epsilon} is specified as \code{eps} in the optinal arguments, its value is used and \code{resolution} is ignored.

The \code{cl.score.method} argument defines how scores are calculated for each SV point (row in \code{sv}) that was assigned to a cluster, (\emph{i.e.}, excluding non-clustered points). If specified as \code{"auto"}, the parameter will be selected based on the rate of neighbor points (\code{"density"}).

If \code{include.raw.results} is \code{TRUE}, some aditional data will be attached to the \code{info} slot of the returned \code{GEVACluster} objects, including the \emph{kNN} tree generated during the intermediate steps.
}
\note{
In density clustering, only the most dense points are clustered. For the unclustered points, the grouping value is set to \code{NA}.
}
\examples{
## Density clustering from a randomly generated input 

# Preparing the data
ginput <- geva.ideal.example()      # Generates a random input example
gsummary <- geva.summarize(ginput)  # Summarizes with the default parameters

# Density clustering
gclust <- geva.dcluster(gsummary)
plot(gclust)

# Density clustering with slightly more resolution
gclust <- geva.dcluster(gsummary, resolution=0.35)
plot(gclust)

}
\seealso{
Other geva.cluster: 
\code{\link{geva.cluster}()},
\code{\link{geva.hcluster}()},
\code{\link{geva.quantiles}()}
}
\concept{geva.cluster}
\keyword{datasets}
