% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_GEVAResults.R
\docType{class}
\name{GEVAResults-class}
\alias{GEVAResults-class}
\alias{show,GEVAResults-method}
\alias{[,GEVAResults,ANY,ANY,ANY-method}
\alias{$,GEVAResults-method}
\alias{plot,GEVAResults,missing-method}
\alias{quantiles,GEVAResults-method}
\alias{results.table,GEVAResults-method}
\alias{sv.data,GEVAResults-method}
\alias{sv,GEVAResults-method}
\alias{infolist,GEVAResults,missing-method}
\alias{infolist,GEVAResults,character-method}
\alias{inputdata,GEVAResults-method}
\alias{inputvalues,GEVAResults-method}
\alias{inputweights,GEVAResults,logical-method}
\alias{inputweights,GEVAResults,missing-method}
\alias{featureTable,GEVAResults-method}
\alias{dim,GEVAResults-method}
\alias{dimnames,GEVAResults-method}
\alias{names,GEVAResults-method}
\alias{length,GEVAResults-method}
\alias{analysis.params,GEVAResults-method}
\alias{levels.GEVAResults}
\alias{head.GEVAResults}
\alias{points.GEVAResults}
\alias{as.expression.GEVAResults}
\title{GEVA Results Table}

\value{
A \code{\linkS4class{GEVAResults}} object
}
\description{
The \code{GEVAResults} class contains the final results from GEVA analyses. It represents the results of multiple statistical approaches from summary/variation data, clustering, quantile detection, and factor analysis (if applicable).
}
\section{Slots}{

\describe{
\item{\code{resultstable}}{\code{data.frame} (\emph{m} lines) with classification results for the genes/probes}

\item{\code{svdata}}{\code{\linkS4class{GEVASummary}} used as input}

\item{\code{quantdata}}{\code{\linkS4class{GEVAQuantiles}} or \code{\linkS4class{GEVAQuantilesAdjusted}} with the final quantile assignments for the summarized data}

\item{\code{factoring}}{\code{data.frame} (\emph{m} lines) with detailed results for the factor analyses, such as p-values for each factor. If there was no factor analysis, this slot is \code{NULL} or empty}

\item{\code{classiftable}}{\code{data.frame} used as reference for the final classification}

\item{\code{info}}{\code{list} of supplementary information}
}}

\section{Methods}{

\sspace\cr\strong{Conversion and coercion}
\describe{
\item{\code{as.expression(x, gsummary, gquants, ...)}}{Gets the expression that reproduces this \code{GEVAResults} object, including function parameters used by \code{geva.finalize}. The \code{gsummary} and \code{gquants} arguments are optional but can be specified to replace the internal \code{GEVASummary} and \code{GEVAQuantiles}, respectively}
}
\sspace\cr\strong{Dimension accessors}
\describe{
\item{\code{dim(x)}}{Returns the dimensions from the \code{resultstable} slot}
\item{\code{dimnames(x)}}{Returns a \code{list} with the row and column names from the \code{results.table} slot. \cr Individual dimension names can also be accessed through \code{rownames} and \code{colnames}}
\item{\code{length(x)}}{Returns the number of rows in the \code{resultstable} slot}
\item{\code{names(x)}}{Returns the column names from the \code{resultstable} slot}
}
\sspace\cr\strong{Plotting}
\describe{
\item{\code{plot(x, y, ...)}}{Draws a SV-plot that highlights the relevant points from adjusted quantiles}
\item{\code{points(x, which, ..., classif)}}{Draws the results points.
\cr If \code{which} (\code{character} vector) is given, plots only the matching genes/probes.
\cr If \code{classif} (\code{character} vector) is given, plots only points with the matching classification}
}
\sspace\cr\strong{Properties}
\describe{
\item{\code{x$name <- value}}{Extracts a column from the \code{resultstable} slot}
\item{\code{x[i, j, ..., drop=TRUE]}}{Extracts the contents from the \code{resultstable} slot}
\item{\code{analysis.params(gobject)}}{Returns a \code{list} of analysis parameters passed to \code{\link{geva.finalize}} or \code{\link{geva.quick}} to obtain this object}
}
\sspace\cr\strong{Sub-slot accessors}
\describe{
\item{\code{featureTable(object)}}{Returns the features \code{data.frame} from the internal \code{\linkS4class{GEVAInput}}}
\item{\code{head(x, ...)}}{Returns the first lines of \code{results.table(x)}}
\item{\code{inputdata(object)}}{Returns the internal \code{\linkS4class{GEVAInput}}}
\item{\code{inputvalues(object)}}{Returns the values \code{matrix} from the internal \code{\linkS4class{GEVAInput}}}
\item{\code{inputweights(object, normalized)}}{Returns the weights \code{matrix} from the internal \code{\linkS4class{GEVAInput}}}
\item{\code{levels(x)}}{Returns the factors used in factor analysis, if present}
}
}

